/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.file.root.RootedPath;
import org.apache.sshd.common.file.util.BaseFileSystem;

public class RootedFileSystem
extends BaseFileSystem<RootedPath> {
    private final Path rootPath;
    private final FileSystem rootFs;

    public RootedFileSystem(RootedFileSystemProvider fileSystemProvider, Path root, Map<String, ?> env) {
        super(fileSystemProvider);
        this.rootPath = Objects.requireNonNull(root, "No root path");
        this.rootFs = root.getFileSystem();
    }

    public FileSystem getRootFileSystem() {
        return this.rootFs;
    }

    public Path getRoot() {
        return this.rootPath;
    }

    @Override
    public RootedFileSystemProvider provider() {
        return (RootedFileSystemProvider)super.provider();
    }

    @Override
    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("close({})", (Object)this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.rootFs.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.rootFs.isReadOnly();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.rootFs.supportedFileAttributeViews();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.rootFs.getUserPrincipalLookupService();
    }

    @Override
    protected RootedPath create(String root, List<String> names) {
        return new RootedPath(this, root, names);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.rootFs.getFileStores();
    }

    public String toString() {
        return this.rootPath.toString();
    }
}

