/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class PropertiesServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final Map<String, ?> properties;

    public PropertiesServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, Map<String, ?> properties) {
        this.delegate = Assert.checkNotNullParam("delegate", delegate);
        this.properties = new HashMap(Assert.checkNotNullParam("properties", properties));
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(PropertiesServerMechanismFactory.combine(properties, this.properties));
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return this.delegate.createAuthenticationMechanism(mechanismName, PropertiesServerMechanismFactory.combine(properties, this.properties), callbackHandler);
    }

    private static Map<String, ?> combine(Map<String, ?> provided, Map<String, ?> configured) {
        HashMap combined = new HashMap(provided);
        combined.putAll(configured);
        return combined;
    }
}

