/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.common.Assert;

public final class StatefulEJBLocator<T>
extends EJBLocator<T> {
    private static final long serialVersionUID = 8229686118358785586L;
    private final SessionID sessionId;

    public StatefulEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, SessionID sessionId) {
        this(viewType, appName, moduleName, beanName, sessionId, Affinity.NONE);
    }

    public StatefulEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, SessionID sessionId, Affinity affinity) {
        this(viewType, appName, moduleName, beanName, "", sessionId, affinity);
    }

    public StatefulEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, SessionID sessionId) {
        this(viewType, appName, moduleName, beanName, distinctName, sessionId, Affinity.NONE);
    }

    public StatefulEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, SessionID sessionId, Affinity affinity) {
        super(viewType, appName, moduleName, beanName, distinctName, affinity);
        Assert.checkNotNullParam("sessionId", sessionId);
        this.sessionId = sessionId;
    }

    public StatefulEJBLocator(Class<T> viewType, EJBIdentifier identifier, SessionID sessionId, Affinity affinity) {
        super(viewType, identifier, affinity);
        Assert.checkNotNullParam("sessionId", sessionId);
        this.sessionId = sessionId;
    }

    public StatefulEJBLocator(Class<T> viewType, EJBIdentifier identifier, SessionID sessionId) {
        this(viewType, identifier, sessionId, Affinity.NONE);
    }

    public StatefulEJBLocator(StatefulEJBLocator<T> original, Affinity newAffinity) {
        super(original, newAffinity);
        this.sessionId = original.sessionId;
    }

    public StatefulEJBLocator(EJBLocator<T> original, SessionID sessionId) {
        super(original, original.getAffinity());
        Assert.checkNotNullParam("sessionId", sessionId);
        this.sessionId = sessionId;
    }

    public StatefulEJBLocator(EJBLocator<T> original, SessionID sessionId, Affinity newAffinity) {
        super(original, newAffinity);
        Assert.checkNotNullParam("sessionId", sessionId);
        this.sessionId = sessionId;
    }

    public static <T> StatefulEJBLocator<T> create(Class<T> viewType, EJBIdentifier identifier, SessionID sessionId, Affinity affinity) {
        return new StatefulEJBLocator<T>(viewType, identifier, sessionId, affinity);
    }

    public StatelessEJBLocator<T> withoutSession() {
        return new StatelessEJBLocator(this, this.getAffinity());
    }

    @Override
    public StatefulEJBLocator<T> withSession(SessionID sessionId) {
        Assert.checkNotNullParam("sessionId", sessionId);
        if (sessionId.equals((Object)this.sessionId)) {
            return this;
        }
        return new StatefulEJBLocator<T>(this, sessionId);
    }

    @Override
    public StatefulEJBLocator<T> withNewAffinity(Affinity affinity) {
        Assert.checkNotNullParam("affinity", affinity);
        return this.getAffinity().equals(affinity) ? this : new StatefulEJBLocator<T>(this, affinity);
    }

    @Override
    public StatefulEJBLocator<T> withSessionAndAffinity(SessionID sessionId, Affinity affinity) {
        Assert.checkNotNullParam("sessionId", sessionId);
        Assert.checkNotNullParam("affinity", affinity);
        return this.getAffinity().equals(affinity) && this.getSessionId().equals((Object)sessionId) ? this : new StatefulEJBLocator<T>(this, sessionId, affinity);
    }

    @Override
    public <S> StatefulEJBLocator<? extends S> narrowTo(Class<S> type) {
        return (StatefulEJBLocator)super.narrowTo(type);
    }

    @Override
    public <S> StatefulEJBLocator<? extends S> narrowAsStateful(Class<S> type) {
        if (type.isAssignableFrom(this.getViewType())) {
            return this;
        }
        throw new ClassCastException(type.toString());
    }

    @Override
    public StatefulEJBLocator<T> asStateful() {
        return this;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StatefulEJBLocator && this.equals((StatefulEJBLocator)other);
    }

    @Override
    public boolean equals(EJBLocator<?> other) {
        return other instanceof StatefulEJBLocator && this.equals((StatefulEJBLocator)other);
    }

    @Override
    public boolean equals(StatefulEJBLocator<?> other) {
        return super.equals(other) && this.sessionId.equals((Object)other.sessionId);
    }

    @Override
    int calculateHashCode() {
        return this.sessionId.hashCode() * 13 + super.calculateHashCode();
    }

    @Override
    public String toString() {
        return String.format("%s, session ID is %s", super.toString(), this.getSessionId());
    }
}

