/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;

public class ActiveMQManagementProxy
implements AutoCloseable {
    private final String username;
    private final String password;
    private final ServerLocator locator;
    private ClientSessionFactory sessionFactory;
    private ClientSession session;
    private ClientRequestor requestor;

    public ActiveMQManagementProxy(ServerLocator locator, String username, String password) {
        this.locator = locator;
        this.username = username;
        this.password = password;
    }

    public void start() throws Exception {
        this.sessionFactory = this.locator.createSessionFactory();
        this.session = this.sessionFactory.createSession(this.username, this.password, false, true, true, false, 0x100000);
        this.requestor = new ClientRequestor(this.session, ActiveMQDefaultConfiguration.getDefaultManagementAddress());
        this.session.start();
    }

    public <T> T invokeOperation(Class<T> type, String resourceName, String operationName, Object ... operationArgs) throws Exception {
        ClientMessage request = this.session.createMessage(false);
        ManagementHelper.putOperationInvocation(request, resourceName, operationName, operationArgs);
        ClientMessage reply = this.requestor.request(request);
        if (ManagementHelper.hasOperationSucceeded(reply)) {
            return (T)ManagementHelper.getResult(reply, type);
        }
        throw new Exception("Failed to invoke " + resourceName + "." + operationName + ". Reason: " + ManagementHelper.getResult(reply, String.class));
    }

    public void stop() throws ActiveMQException {
        this.session.stop();
    }

    @Override
    public void close() throws Exception {
        this.requestor.close();
        this.session.close();
        this.sessionFactory.close();
    }
}

