/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannelProbeHandler;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.StateTransferException;
import org.jgroups.UpHandler;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.Promise;
import org.jgroups.util.StackType;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="JGroups channel")
public class JChannel
implements Closeable {
    protected Receiver receiver;
    protected Address local_addr;
    protected String name;
    protected String cluster_name;
    protected View view;
    protected volatile State state = State.OPEN;
    protected ProtocolStack prot_stack;
    protected UpHandler up_handler;
    protected Set<ChannelListener> channel_listeners;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected List<AddressGenerator> address_generators;
    protected final Promise<StateTransferResult> state_promise = new Promise();
    protected boolean state_transfer_supported;
    protected volatile boolean flush_supported;
    protected final DiagnosticsHandler.ProbeHandler probe_handler = new JChannelProbeHandler(this);
    protected long sent_msgs;
    protected long received_msgs;
    protected long sent_bytes;
    protected long received_bytes;
    @ManagedAttribute(description="Collect channel statistics", writable=true)
    protected boolean stats = true;
    @ManagedAttribute(description="Whether or not to discard messages sent by this channel", writable=true)
    protected boolean discard_own_messages;

    public JChannel(boolean create_protocol_stack) {
        if (create_protocol_stack) {
            try {
                this.init(ConfiguratorFactory.getStackConfigurator("udp.xml"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JChannel() throws Exception {
        this("udp.xml");
    }

    public JChannel(String props) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(props));
    }

    public JChannel(InputStream input) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(input));
    }

    public JChannel(URL properties) throws Exception {
        this(properties.openStream());
    }

    public JChannel(ProtocolStackConfigurator configurator) throws Exception {
        this.init(configurator);
    }

    public JChannel(Protocol ... protocols) throws Exception {
        this(Arrays.asList(protocols));
    }

    public JChannel(List<Protocol> protocols) throws Exception {
        this.prot_stack = new ProtocolStack().setChannel(this);
        for (Protocol prot : protocols) {
            this.prot_stack.addProtocol(prot);
            prot.setProtocolStack(this.prot_stack);
        }
        this.prot_stack.init();
        StackType ip_version = Util.getIpStackType();
        TP transport = (TP)protocols.get(0);
        InetAddress resolved_addr = (InetAddress)Configurator.getValueFromProtocol((Protocol)transport, "bind_addr");
        if (resolved_addr != null) {
            ip_version = resolved_addr instanceof Inet6Address ? StackType.IPv6 : StackType.IPv4;
        } else if (ip_version == StackType.Dual) {
            ip_version = StackType.IPv4;
        }
        List<Protocol> prots = this.prot_stack.getProtocols();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Protocol prot : prots) {
            Configurator.resolveAndAssignFields(prot, map, ip_version);
        }
    }

    public JChannel(JChannel ch) throws Exception {
        this.init(ch);
        this.discard_own_messages = ch.discard_own_messages;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public JChannel setReceiver(Receiver r) {
        this.receiver = r;
        return this;
    }

    public JChannel receiver(Receiver r) {
        return this.setReceiver(r);
    }

    public Address getAddress() {
        return this.address();
    }

    public Address address() {
        return this.state == State.CLOSED ? null : this.local_addr;
    }

    public String getName() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public JChannel name(String name) {
        return this.setName(name);
    }

    public String clusterName() {
        return this.getClusterName();
    }

    public View getView() {
        return this.view();
    }

    public View view() {
        return this.state == State.CONNECTED ? this.view : null;
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public ProtocolStack stack() {
        return this.prot_stack;
    }

    public UpHandler getUpHandler() {
        return this.up_handler;
    }

    public JChannel setUpHandler(UpHandler h) {
        this.up_handler = h;
        return this;
    }

    public boolean getStats() {
        return this.stats;
    }

    public boolean stats() {
        return this.stats;
    }

    public JChannel setStats(boolean stats) {
        this.stats = stats;
        return this;
    }

    public JChannel stats(boolean stats) {
        this.stats = stats;
        return this;
    }

    public boolean getDiscardOwnMessages() {
        return this.discard_own_messages;
    }

    public JChannel setDiscardOwnMessages(boolean flag) {
        this.discard_own_messages = flag;
        return this;
    }

    public boolean flushSupported() {
        return this.flush_supported;
    }

    @ManagedAttribute(name="address")
    public String getAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "n/a";
    }

    @ManagedAttribute(name="address_uuid")
    public String getAddressAsUUID() {
        return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
    }

    @ManagedAttribute(writable=true, description="The logical name of this channel. Stays with the channel until the channel is closed")
    public JChannel setName(String name) {
        if (name != null) {
            if (this.isConnected()) {
                throw new IllegalStateException("name cannot be set if channel is connected (should be done before)");
            }
            this.name = name;
            if (this.local_addr != null) {
                NameCache.add(this.local_addr, this.name);
            }
        }
        return this;
    }

    @ManagedAttribute(description="Returns cluster name this channel is connected to")
    public String getClusterName() {
        return this.state == State.CONNECTED ? this.cluster_name : null;
    }

    @ManagedAttribute(name="view")
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @ManagedAttribute(description="The current state")
    public String getState() {
        return this.state.toString();
    }

    @ManagedAttribute
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @ManagedAttribute
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @ManagedAttribute
    public boolean isConnecting() {
        return this.state == State.CONNECTING;
    }

    @ManagedAttribute
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @ManagedAttribute
    public long getSentMessages() {
        return this.sent_msgs;
    }

    @ManagedAttribute
    public long getSentBytes() {
        return this.sent_bytes;
    }

    @ManagedAttribute
    public long getReceivedMessages() {
        return this.received_msgs;
    }

    @ManagedAttribute
    public long getReceivedBytes() {
        return this.received_bytes;
    }

    @ManagedAttribute
    public static String getVersion() {
        return Version.printDescription();
    }

    public synchronized JChannel addChannelListener(ChannelListener listener) {
        if (listener == null) {
            return this;
        }
        if (this.channel_listeners == null) {
            this.channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
        }
        this.channel_listeners.add(listener);
        return this;
    }

    public synchronized JChannel removeChannelListener(ChannelListener listener) {
        if (this.channel_listeners != null && listener != null) {
            this.channel_listeners.remove(listener);
        }
        return this;
    }

    public synchronized JChannel clearChannelListeners() {
        if (this.channel_listeners != null) {
            this.channel_listeners.clear();
        }
        return this;
    }

    public JChannel addAddressGenerator(AddressGenerator address_generator) {
        if (address_generator == null) {
            return this;
        }
        if (this.address_generators == null) {
            this.address_generators = new ArrayList<AddressGenerator>(3);
        }
        this.address_generators.add(address_generator);
        return this;
    }

    public boolean removeAddressGenerator(AddressGenerator address_generator) {
        return address_generator != null && this.address_generators != null && this.address_generators.remove(address_generator);
    }

    public String getProperties() {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(true) : null;
    }

    @ManagedOperation
    public JChannel resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
        return this;
    }

    @ManagedOperation
    public String printProtocolSpec(boolean include_props) {
        ProtocolStack ps = this.getProtocolStack();
        return ps != null ? ps.printProtocolSpec(include_props) : null;
    }

    @ManagedOperation
    public Map<String, Map<String, Object>> dumpStats() {
        Map<String, Map<String, Object>> retval = this.prot_stack.dumpStats();
        retval.put("channel", this.dumpChannelStats());
        return retval;
    }

    public Map<String, Map<String, Object>> dumpStats(String protocol_name, List<String> attrs) {
        return this.prot_stack.dumpStats(protocol_name, attrs);
    }

    @ManagedOperation
    public Map<String, Map<String, Object>> dumpStats(String protocol_name) {
        return this.prot_stack.dumpStats(protocol_name, null);
    }

    protected Map<String, Object> dumpChannelStats() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("sent_msgs", this.sent_msgs);
        retval.put("sent_bytes", this.sent_bytes);
        retval.put("received_msgs", this.received_msgs);
        retval.put("received_bytes", this.received_bytes);
        return retval;
    }

    @ManagedOperation(description="Connects the channel to a group")
    public synchronized JChannel connect(String cluster_name) throws Exception {
        return this.connect(cluster_name, true);
    }

    @ManagedOperation(description="Connects the channel to a group")
    protected synchronized JChannel connect(String cluster_name, boolean useFlushIfPresent) throws Exception {
        if (!this._preConnect(cluster_name)) {
            return this;
        }
        Event connect_event = new Event(useFlushIfPresent ? 92 : 2, cluster_name);
        this._connect(connect_event);
        this.state = State.CONNECTED;
        this.notifyChannelConnected(this);
        return this;
    }

    public synchronized JChannel connect(String cluster_name, Address target, long timeout) throws Exception {
        return this.connect(cluster_name, target, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JChannel connect(String cluster_name, Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        if (!this._preConnect(cluster_name)) {
            return this;
        }
        boolean canFetchState = false;
        try {
            Event connect_event = new Event(useFlushIfPresent ? 93 : 80, cluster_name);
            this._connect(connect_event);
            this.state = State.CONNECTED;
            this.notifyChannelConnected(this);
            boolean bl = canFetchState = this.view != null && this.view.size() > 1;
            if (canFetchState) {
                this.getState(target, timeout, false);
            }
        }
        finally {
            if (this.flushSupported() && useFlushIfPresent && (canFetchState || this.state != State.CONNECTED)) {
                this.stopFlush();
            }
        }
        return this;
    }

    @ManagedOperation(description="Disconnects the channel if connected")
    public synchronized JChannel disconnect() {
        switch (this.state) {
            case OPEN: 
            case CLOSED: {
                break;
            }
            case CONNECTING: 
            case CONNECTED: {
                if (this.cluster_name != null) {
                    try {
                        this.down(new Event(4, this.local_addr));
                    }
                    catch (Throwable t) {
                        this.log.error(Util.getMessage("DisconnectFailure"), this.local_addr, t);
                    }
                }
                this.state = State.OPEN;
                this.stopStack(true, false);
                this.notifyChannelDisconnected(this);
                this.init();
                break;
            }
            default: {
                throw new IllegalStateException("state " + (Object)((Object)this.state) + " unknown");
            }
        }
        return this;
    }

    @Override
    @ManagedOperation(description="Disconnects and destroys the channel")
    public synchronized void close() {
        this._close(true);
    }

    public JChannel send(Message msg) throws Exception {
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        this.checkClosedOrNotConnected();
        this.down(msg);
        return this;
    }

    public JChannel send(Address dst, Object obj) throws Exception {
        return this.send(new Message(dst, obj));
    }

    public JChannel send(Address dst, byte[] buf) throws Exception {
        return this.send(new Message(dst, buf));
    }

    public JChannel send(Address dst, byte[] buf, int offset, int length) throws Exception {
        return this.send(new Message(dst, buf, offset, length));
    }

    public JChannel getState(Address target, long timeout) throws Exception {
        return this.getState(target, timeout, true);
    }

    public JChannel getState(Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        Callable<Boolean> flusher = () -> Util.startFlush(this);
        return this.getState(target, timeout, useFlushIfPresent ? flusher : null);
    }

    public JChannel startFlush(boolean automatic_resume) throws Exception {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        try {
            this.down(new Event(68));
            JChannel jChannel = this;
            return jChannel;
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush();
            }
        }
    }

    public JChannel startFlush(List<Address> flushParticipants, boolean automatic_resume) throws Exception {
        boolean validParticipants;
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        View v = this.getView();
        boolean bl = validParticipants = v != null && v.getMembers().containsAll(flushParticipants);
        if (!validParticipants) {
            throw new IllegalArgumentException("Current view " + v + " does not contain all flush participants " + flushParticipants);
        }
        try {
            this.down(new Event(68, flushParticipants));
            JChannel jChannel = this;
            return jChannel;
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush(flushParticipants);
            }
        }
    }

    public JChannel stopFlush() {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70));
        return this;
    }

    public JChannel stopFlush(List<Address> flushParticipants) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70, flushParticipants));
        return this;
    }

    public Object down(Event evt) {
        if (evt == null) {
            return null;
        }
        return this.prot_stack.down(evt);
    }

    public Object down(Message msg) {
        if (msg == null) {
            return null;
        }
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        return this.prot_stack.down(msg);
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View tmp = (View)evt.getArg();
                this.view = tmp instanceof MergeView ? new View(tmp.getViewId(), tmp.getMembers()) : tmp;
                if (this.state == State.CONNECTED) break;
                this.state = State.CONNECTED;
                break;
            }
            case 56: {
                Map cfg = (Map)evt.getArg();
                if (cfg == null) break;
                if (cfg.containsKey("state_transfer")) {
                    this.state_transfer_supported = (Boolean)cfg.get("state_transfer");
                }
                if (!cfg.containsKey("flush_supported")) break;
                this.flush_supported = (Boolean)cfg.get("flush_supported");
                break;
            }
            case 20: {
                StateTransferResult result = (StateTransferResult)evt.getArg();
                if (this.up_handler != null) {
                    try {
                        Object retval = this.up_handler.up(evt);
                        this.state_promise.setResult(result);
                        return retval;
                    }
                    catch (Throwable t) {
                        this.state_promise.setResult(new StateTransferResult(t));
                    }
                }
                if (this.receiver == null) break;
                try {
                    if (result.hasBuffer()) {
                        byte[] tmp_state = result.getBuffer();
                        ByteArrayInputStream input = new ByteArrayInputStream(tmp_state);
                        this.receiver.setState(input);
                    }
                    this.state_promise.setResult(result);
                }
                catch (Throwable t) {
                    this.state_promise.setResult(new StateTransferResult(t));
                }
                break;
            }
            case 73: {
                this.state_promise.setResult((StateTransferResult)evt.getArg());
                break;
            }
            case 71: {
                if (this.up_handler != null) {
                    return this.up_handler.up(evt);
                }
                InputStream is = (InputStream)evt.getArg();
                if (is == null || this.receiver == null) break;
                try {
                    this.receiver.setState(is);
                    break;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failed calling setState() in state requester", t);
                }
            }
            case 72: {
                if (this.receiver == null || evt.getArg() == null) break;
                try {
                    this.receiver.getState((OutputStream)evt.getArg());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("failed calling getState() in state provider", e);
                }
            }
            case 91: {
                return this.local_addr;
            }
            case 8: {
                Address tmp_addr = (Address)evt.arg();
                if (tmp_addr == null) break;
                this.local_addr = tmp_addr;
                if (this.name == null || this.name.isEmpty()) break;
                NameCache.add(this.local_addr, this.name);
                break;
            }
        }
        if (this.up_handler != null) {
            return this.up_handler.up(evt);
        }
        if (this.receiver != null) {
            return this.invokeCallback(evt.getType(), evt.getArg());
        }
        return null;
    }

    public Object up(Message msg) {
        if (this.stats) {
            ++this.received_msgs;
            this.received_bytes += (long)msg.getLength();
        }
        if (this.discard_own_messages && this.local_addr != null && msg.getSrc() != null && this.local_addr.equals(msg.getSrc())) {
            return null;
        }
        if (this.up_handler != null) {
            return this.up_handler.up(msg);
        }
        if (this.receiver != null) {
            this.receiver.receive(msg);
        }
        return null;
    }

    public JChannel up(MessageBatch batch) {
        if (this.stats) {
            this.received_msgs += (long)batch.size();
            this.received_bytes += (long)batch.length();
        }
        if (this.discard_own_messages && this.local_addr != null && batch.sender() != null && this.local_addr.equals(batch.sender())) {
            return this;
        }
        if (this.up_handler != null) {
            try {
                this.up_handler.up(batch);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("UpHandlerFailure"), t);
            }
            return this;
        }
        if (this.receiver != null) {
            try {
                this.receiver.receive(batch);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("ReceiverFailure"), t);
            }
        }
        return this;
    }

    @ManagedOperation
    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("local_addr=").append(this.local_addr).append('\n').append("cluster_name=").append(this.cluster_name).append('\n').append("my_view=").append(this.view).append('\n').append("state=").append((Object)this.state).append('\n');
        if (details) {
            sb.append("discard_own_messages=").append(this.discard_own_messages).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.getProperties()).append('\n');
        }
        return sb.toString();
    }

    protected boolean _preConnect(String cluster_name) throws Exception {
        if (cluster_name == null) {
            throw new IllegalArgumentException("cluster name cannot be null");
        }
        if (this.state == State.CONNECTED) {
            this.log.trace("already connected to %s", this.cluster_name);
            return false;
        }
        this.checkClosed();
        this.setAddress();
        State old_state = this.state;
        this.state = State.CONNECTING;
        try {
            this.startStack(cluster_name);
        }
        catch (Exception ex) {
            this.state = old_state;
            throw ex;
        }
        return true;
    }

    protected JChannel _connect(Event evt) throws Exception {
        try {
            this.down(evt);
            return this;
        }
        catch (Exception ex) {
            this.cleanup();
            throw ex;
        }
    }

    protected void cleanup() {
        this.stopStack(true, false);
        this.state = State.OPEN;
        this.init();
    }

    protected JChannel getState(Address target, long timeout, Callable<Boolean> flushInvoker) throws Exception {
        boolean initiateFlush;
        this.checkClosedOrNotConnected();
        if (!this.state_transfer_supported) {
            throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the state transfer protocols to your configuration");
        }
        if (target == null) {
            target = this.determineCoordinator();
        }
        if (Objects.equals(target, this.local_addr)) {
            this.log.trace(this.local_addr + ": cannot get state from myself (" + target + "): probably the first member");
            return this;
        }
        boolean bl = initiateFlush = this.flushSupported() && flushInvoker != null;
        if (initiateFlush) {
            boolean successfulFlush = false;
            try {
                successfulFlush = flushInvoker.call();
            }
            catch (Throwable e) {
                successfulFlush = false;
            }
            if (!successfulFlush) {
                throw new IllegalStateException("Node " + this.local_addr + " could not flush the cluster for state retrieval");
            }
        }
        this.state_promise.reset();
        StateTransferInfo state_info = new StateTransferInfo(target, timeout);
        long start = System.currentTimeMillis();
        this.down(new Event(19, state_info));
        StateTransferResult result = this.state_promise.getResult(state_info.timeout);
        if (initiateFlush) {
            this.stopFlush();
        }
        if (result == null) {
            throw new StateTransferException("timeout during state transfer (" + (System.currentTimeMillis() - start) + "ms)");
        }
        if (result.hasException()) {
            throw new StateTransferException("state transfer failed", result.getException());
        }
        return this;
    }

    protected Object invokeCallback(int type, Object arg) {
        switch (type) {
            case 6: {
                this.receiver.viewAccepted((View)arg);
                break;
            }
            case 9: {
                List<Address> suspects = arg instanceof Address ? Collections.singletonList((Address)arg) : (List<Address>)arg;
                suspects.forEach(this.receiver::suspect);
                break;
            }
            case 17: {
                byte[] tmp_state = null;
                if (this.receiver != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                    try {
                        this.receiver.getState(output);
                        tmp_state = output.toByteArray();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(this.local_addr + ": failed getting state from application", e);
                    }
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 10: {
                this.receiver.block();
                return true;
            }
            case 75: {
                this.receiver.unblock();
            }
        }
        return null;
    }

    protected final JChannel init(ProtocolStackConfigurator configurator) throws Exception {
        List<ProtocolConfiguration> configs = configurator.getProtocolStack();
        configs.forEach(ProtocolConfiguration::substituteVariables);
        this.prot_stack = new ProtocolStack(this);
        this.prot_stack.setup(configs);
        return this;
    }

    protected final JChannel init(JChannel ch) throws Exception {
        if (ch == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.prot_stack = new ProtocolStack(this);
        this.prot_stack.setup(ch.getProtocolStack());
        return this;
    }

    protected JChannel init() {
        if (this.local_addr != null) {
            this.down(new Event(90, this.local_addr));
        }
        this.local_addr = null;
        this.cluster_name = null;
        this.view = null;
        return this;
    }

    protected JChannel startStack(String cluster_name) throws Exception {
        this.checkClosed();
        this.cluster_name = cluster_name;
        this.prot_stack.startStack();
        this.view = new View(this.local_addr, 0L, Collections.singletonList(this.local_addr));
        TP transport = this.prot_stack.getTransport();
        transport.registerProbeHandler(this.probe_handler);
        return this;
    }

    protected JChannel setAddress() {
        Address old_addr = this.local_addr;
        this.local_addr = this.generateAddress();
        if (old_addr != null) {
            this.down(new Event(90, old_addr));
        }
        if (this.name == null || this.name.isEmpty()) {
            this.name = Util.generateLocalName();
        }
        if (this.name != null && !this.name.isEmpty()) {
            NameCache.add(this.local_addr, this.name);
        }
        Event evt = new Event(8, this.local_addr);
        this.down(evt);
        if (this.up_handler != null) {
            this.up_handler.up(evt);
        }
        return this;
    }

    protected Address generateAddress() {
        int i;
        if (this.address_generators == null || this.address_generators.isEmpty()) {
            return UUID.randomUUID();
        }
        if (this.address_generators.size() == 1) {
            return this.address_generators.get(0).generateAddress();
        }
        Address[] addrs = new Address[this.address_generators.size()];
        for (i = 0; i < addrs.length; ++i) {
            addrs[i] = this.address_generators.get(i).generateAddress();
        }
        for (i = 0; i < addrs.length; ++i) {
            if (addrs[i] instanceof ExtendedUUID) continue;
            this.log.error("address generator %s does not subclass %s which is required if multiple address generators are installed, removing it", addrs[i].getClass().getSimpleName(), ExtendedUUID.class.getSimpleName());
            addrs[i] = null;
        }
        UUID uuid = null;
        for (int i2 = 0; i2 < addrs.length; ++i2) {
            if (addrs[i2] == null) continue;
            if (uuid == null) {
                uuid = (ExtendedUUID)addrs[i2];
                continue;
            }
            ((ExtendedUUID)uuid).addContents((ExtendedUUID)addrs[i2]);
        }
        return uuid != null ? uuid : UUID.randomUUID();
    }

    protected JChannel checkClosed() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("channel is closed");
        }
        return this;
    }

    protected JChannel checkClosedOrNotConnected() {
        State tmp = this.state;
        if (tmp == State.CLOSED) {
            throw new IllegalStateException("channel is closed");
        }
        if (tmp != State.CONNECTING && tmp != State.CONNECTED) {
            throw new IllegalStateException("channel is disconnected");
        }
        return this;
    }

    protected JChannel _close(boolean disconnect) {
        Address old_addr = this.local_addr;
        if (this.state == State.CLOSED) {
            return this;
        }
        if (disconnect) {
            this.disconnect();
        }
        this.stopStack(true, true);
        this.state = State.CLOSED;
        this.notifyChannelClosed(this);
        this.init();
        if (old_addr != null) {
            NameCache.remove(old_addr);
        }
        return this;
    }

    protected JChannel stopStack(boolean stop, boolean destroy) {
        if (this.prot_stack != null) {
            try {
                if (stop) {
                    this.prot_stack.stopStack(this.cluster_name);
                }
                if (destroy) {
                    this.prot_stack.destroy();
                }
            }
            catch (Exception e) {
                this.log.error(Util.getMessage("StackDestroyFailure"), e);
            }
            TP transport = this.prot_stack.getTransport();
            if (transport != null) {
                transport.unregisterProbeHandler(this.probe_handler);
            }
        }
        return this;
    }

    protected Address determineCoordinator() {
        return this.view != null ? this.view.getCoord() : null;
    }

    protected JChannel notifyChannelConnected(JChannel c) {
        return this.notifyListeners(l -> l.channelConnected(c), "channelConnected");
    }

    protected JChannel notifyChannelDisconnected(JChannel c) {
        return this.notifyListeners(l -> l.channelDisconnected(c), "channelDisconnected()");
    }

    protected JChannel notifyChannelClosed(JChannel c) {
        return this.notifyListeners(l -> l.channelClosed(c), "channelClosed()");
    }

    protected JChannel notifyListeners(Consumer<ChannelListener> func, String msg) {
        if (this.channel_listeners != null) {
            try {
                this.channel_listeners.forEach(func);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("CallbackException"), msg, t);
            }
        }
        return this;
    }

    public static enum State {
        OPEN,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

