/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class DefaultSSLContextFactory
implements SSLContextFactory {
    @Override
    public SSLContext getSSLContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        boolean useDefaultSslContext = ConfigurationHelper.getBooleanProperty("useDefaultSslContext", false, additionalOpts);
        if (useDefaultSslContext) {
            log.debug("Using the Default JDK SSLContext.");
            return SSLContext.getDefault();
        }
        log.debugf("Creating JDK SSLContext with %s", (Object)config);
        return new SSLSupport(config).createContext();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

