/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.wildfly.common.Assert;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class JsonWebToken {
    public static final String EMAIL = "email";
    public static final String EXP = "exp";
    public static final String FAMILY_NAME = "family_name";
    public static final String GIVEN_NAME = "given_name";
    public static final String IAT = "iat";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NAME = "name";
    public static final String NICKNAME = "nickname";
    public static final String NBF = "nbf";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String SUB = "sub";
    private final JwtClaims jwtClaims;

    public JsonWebToken(JwtClaims jwtClaims) {
        Assert.checkNotNullParam("jwtClaims", jwtClaims);
        this.jwtClaims = jwtClaims;
    }

    public String getIssuer() {
        try {
            return this.jwtClaims.getIssuer();
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public String getSubject() {
        try {
            return this.jwtClaims.getSubject();
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public List<String> getAudience() {
        try {
            return this.jwtClaims.getAudience();
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public Long getExpiration() {
        return this.getClaimValueAsLong(EXP);
    }

    public boolean isExpired() {
        Long expiration = this.getExpiration();
        return expiration != null && expiration != 0L ? (long)JsonWebToken.getCurrentTimeInSeconds() > expiration : false;
    }

    public Long getNotBefore() {
        return this.getClaimValueAsLong(NBF);
    }

    public boolean isNotBefore() {
        Long notBefore = this.getNotBefore();
        return notBefore != null ? (long)JsonWebToken.getCurrentTimeInSeconds() >= notBefore : true;
    }

    public boolean isActive() {
        return !this.isExpired() && this.isNotBefore();
    }

    public Long getIssuedAt() {
        return this.getClaimValueAsLong(IAT);
    }

    public String getID() {
        try {
            return this.jwtClaims.getJwtId();
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public Set<String> getClaimNames() {
        return new HashSet<String>(this.jwtClaims.getClaimNames());
    }

    public boolean hasClaim(String claimName) {
        Assert.checkNotNullParam("claimName", claimName);
        return this.jwtClaims.hasClaim(claimName);
    }

    public Object getClaimValue(String claimName) {
        Assert.checkNotNullParam("claimName", claimName);
        return this.jwtClaims.getClaimValue(claimName);
    }

    public <T> T getClaimValue(String claimName, Class<T> type) {
        Assert.checkNotNullParam("claimName", claimName);
        try {
            return this.jwtClaims.getClaimValue(claimName, type);
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public String getClaimValueAsString(String claimName) {
        Assert.checkNotNullParam("claimName", claimName);
        return this.jwtClaims.getClaimValueAsString(claimName);
    }

    public List<String> getStringListClaimValue(String claimName) {
        Assert.checkNotNullParam("claimName", claimName);
        try {
            return this.jwtClaims.getStringListClaimValue(claimName);
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public String getName() {
        return this.getClaimValueAsString(NAME);
    }

    public String getPrincipalName(OidcClientConfiguration deployment) {
        String attr = SUB;
        if (deployment.getPrincipalAttribute() != null) {
            attr = deployment.getPrincipalAttribute();
        }
        switch (attr) {
            case "sub": {
                return this.getSubject();
            }
            case "email": {
                return this.getEmail();
            }
            case "preferred_username": {
                return this.getPreferredUsername();
            }
            case "name": {
                return this.getName();
            }
            case "given_name": {
                return this.getGivenName();
            }
            case "family_name": {
                return this.getFamilyName();
            }
            case "nickname": {
                return this.getNickName();
            }
        }
        return this.getSubject();
    }

    public String getGivenName() {
        return this.getClaimValueAsString(GIVEN_NAME);
    }

    public String getFamilyName() {
        return this.getClaimValueAsString(FAMILY_NAME);
    }

    public String getMiddleName() {
        return this.getClaimValueAsString(MIDDLE_NAME);
    }

    public String getNickName() {
        return this.getClaimValueAsString(NICKNAME);
    }

    public String getPreferredUsername() {
        return this.getClaimValueAsString(PREFERRED_USERNAME);
    }

    public String getEmail() {
        return this.getClaimValueAsString(EMAIL);
    }

    private static int getCurrentTimeInSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    Long getClaimValueAsLong(String claimName) {
        try {
            Long claimValue = this.jwtClaims.getClaimValue(claimName, Long.class);
            if (claimValue == null) {
                claimValue = 0L;
            }
            return claimValue;
        }
        catch (MalformedClaimException e) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
    }

    public static JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = Json.createValue(value.toString());
        } else if (value instanceof Long || value instanceof Integer) {
            jsonValue = Json.createValue(((Number)value).longValue());
        } else if (value instanceof Number) {
            jsonValue = Json.createValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            jsonValue = (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            jsonValue = JsonWebToken.toJsonArray((Collection)value);
        } else if (value instanceof Map) {
            JsonObject entryJsonObject = JsonWebToken.replaceMap((Map)value);
            jsonValue = entryJsonObject;
        }
        return jsonValue;
    }

    public static JsonObject replaceMap(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = JsonWebToken.replaceMap((Map)entryValue);
                builder.add(entry.getKey(), entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)JsonWebToken.wrapValue(entryValue);
                builder.add(entry.getKey(), array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    private static JsonArray toJsonArray(Collection<?> collection) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (Object element : collection) {
            if (element instanceof String) {
                arrayBuilder.add(element.toString());
                continue;
            }
            if (element == null) {
                arrayBuilder.add(JsonValue.NULL);
                continue;
            }
            JsonValue jvalue = JsonWebToken.wrapValue(element);
            arrayBuilder.add(jvalue);
        }
        return arrayBuilder.build();
    }
}

