/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInterceptorRejectedPacketException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQRoutingException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.w3c.dom.Node;

@MessageBundle(projectCode="AMQ")
public interface ActiveMQClientMessageBundle {
    public static final ActiveMQClientMessageBundle BUNDLE = Messages.getBundle(ActiveMQClientMessageBundle.class);

    @Message(id=219000, value="ClientSession closed while creating session")
    public ActiveMQInternalErrorException clientSessionClosed();

    @Message(id=219001, value="Failed to create session")
    public ActiveMQInternalErrorException failedToCreateSession(@Cause Throwable var1);

    @Message(id=219003, value="Queue can not be both durable and temporary")
    public ActiveMQInternalErrorException queueMisConfigured();

    @Message(id=219004, value="Failed to initialise session factory")
    public ActiveMQInternalErrorException failedToInitialiseSessionFactory(@Cause Exception var1);

    @Message(id=219005, value="Exception in Netty transport")
    public ActiveMQInternalErrorException nettyError();

    @Message(id=219006, value="Channel disconnected")
    public ActiveMQNotConnectedException channelDisconnected();

    @Message(id=219007, value="Cannot connect to server(s). Tried with all available servers.")
    public ActiveMQNotConnectedException cannotConnectToServers();

    @Message(id=219008, value="Failed to connect to any static connectors")
    public ActiveMQNotConnectedException cannotConnectToStaticConnectors(@Cause Exception var1);

    @Message(id=219009, value="Failed to connect to any static connectors")
    public ActiveMQNotConnectedException cannotConnectToStaticConnectors2();

    @Message(id=219010, value="Connection is destroyed")
    public ActiveMQNotConnectedException connectionDestroyed();

    @Message(id=219011, value="Did not receive data from server for {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQConnectionTimedOutException connectionTimedOut(Connection var1);

    @Message(id=219012, value="Timed out waiting to receive initial broadcast from cluster")
    public ActiveMQConnectionTimedOutException connectionTimedOutInInitialBroadcast();

    @Message(id=219013, value="Timed out waiting to receive cluster topology. Group:{0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup var1);

    @Message(id=219014, value="Timed out after waiting {0} ms for response when sending packet {1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQConnectionTimedOutException timedOutSendingPacket(long var1, Byte var3);

    @Message(id=219015, value="The connection was disconnected because of server shutdown")
    public ActiveMQDisconnectedException disconnected();

    @Message(id=219016, value="Connection failure detected. Unblocking a blocking call that will never get a response")
    public ActiveMQUnBlockedException unblockingACall(@Cause Throwable var1);

    @Message(id=219017, value="Consumer is closed")
    public ActiveMQObjectClosedException consumerClosed();

    @Message(id=219018, value="Producer is closed")
    public ActiveMQObjectClosedException producerClosed();

    @Message(id=219019, value="Session is closed")
    public ActiveMQObjectClosedException sessionClosed();

    @Message(id=219020, value="Cannot call receive(...) - a MessageHandler is set")
    public ActiveMQIllegalStateException messageHandlerSet();

    @Message(id=219021, value="Cannot set MessageHandler - consumer is in receive(...)")
    public ActiveMQIllegalStateException inReceive();

    @Message(id=219022, value="Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException headerSizeTooBig(Integer var1);

    @Message(id=219023, value="The large message lost connection with its session, either because of a rollback or a closed session")
    public ActiveMQIllegalStateException largeMessageLostSession();

    @Message(id=219024, value="Could not select a TransportConfiguration to create SessionFactory")
    public ActiveMQIllegalStateException noTCForSessionFactory();

    @Message(id=219025, value="Error saving the message body")
    public ActiveMQLargeMessageException errorSavingBody(@Cause Exception var1);

    @Message(id=219026, value="Error reading the LargeMessageBody")
    public ActiveMQLargeMessageException errorReadingBody(@Cause Exception var1);

    @Message(id=219027, value="Error closing stream from LargeMessageBody")
    public ActiveMQLargeMessageException errorClosingLargeMessage(@Cause Exception var1);

    @Message(id=219028, value="Timeout waiting for LargeMessage Body")
    public ActiveMQLargeMessageException timeoutOnLargeMessage();

    @Message(id=219029, value="Error writing body of message")
    public ActiveMQLargeMessageException errorWritingLargeMessage(@Cause Exception var1);

    @Message(id=219030, value="The transaction was rolled back on failover to a backup server")
    public ActiveMQTransactionRolledBackException txRolledBack();

    @Message(id=219031, value="The transaction was rolled back on failover however commit may have been successful")
    public ActiveMQTransactionOutcomeUnknownException txOutcomeUnknown();

    @Message(id=219032, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidType(Object var1);

    @Message(id=219033, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidEncodeType(Object var1);

    @Message(id=219034, value="Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidManagementParam(Object var1);

    @Message(id=219035, value="Invalid window size {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidWindowSize(Integer var1);

    @Message(id=219037, value="Invalid last Received Command ID: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidCommandID(Integer var1);

    @Message(id=219038, value="Cannot find channel with id {0} to close", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noChannelToClose(Long var1);

    @Message(id=219039, value="Close Listener cannot be null")
    public IllegalArgumentException closeListenerCannotBeNull();

    @Message(id=219040, value="Fail Listener cannot be null")
    public IllegalArgumentException failListenerCannotBeNull();

    @Message(id=219041, value="Connection already exists with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException connectionExists(Object var1);

    @Message(id=219042, value="Invalid argument null listener")
    public IllegalArgumentException nullListener();

    @Message(id=219043, value="Invalid argument null handler")
    public IllegalArgumentException nullHandler();

    @Message(id=219045, value="the first node to be compared is null")
    public IllegalArgumentException firstNodeNull();

    @Message(id=219046, value="the second node to be compared is null")
    public IllegalArgumentException secondNodeNull();

    @Message(id=219047, value="nodes have different node names")
    public IllegalArgumentException nodeHaveDifferentNames();

    @Message(id=219048, value="nodes have a different number of attributes")
    public IllegalArgumentException nodeHaveDifferentAttNumber();

    @Message(id=219049, value="attribute {0}={1} does not match", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException attsDontMatch(String var1, String var2);

    @Message(id=219050, value="one node has children and the other does not")
    public IllegalArgumentException oneNodeHasChildren();

    @Message(id=219051, value="nodes have a different number of children")
    public IllegalArgumentException nodeHasDifferentChildNumber();

    @Message(id=219052, value="Element {0} requires a valid Boolean value, but ''{1}'' cannot be parsed as a Boolean", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeBoolean(Node var1, String var2);

    @Message(id=219053, value="Element {0} requires a valid Double value, but ''{1}'' cannot be parsed as a Double", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeDouble(Node var1, String var2);

    @Message(id=219054, value="Element {0} requires a valid Integer value, but ''{1}'' cannot be parsed as an Integer", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeInteger(Node var1, String var2);

    @Message(id=219055, value="Element {0} requires a valid Long value, but ''{1}'' cannot be parsed as a Long", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustBeLong(Node var1, String var2);

    @Message(id=219057, value="Error decoding password")
    public IllegalArgumentException errordecodingPassword(@Cause Exception var1);

    @Message(id=219058, value="Address \"{0}\" is full. Message encode size = {1}B", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAddressFullException addressIsFull(String var1, int var2);

    @Message(id=219059, value="Interceptor {0} rejected packet in a blocking call. This call will never complete.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInterceptorRejectedPacketException interceptorRejectedPacket(String var1);

    @Message(id=219060, value="Large Message Transmission interrupted on consumer shutdown.")
    public ActiveMQLargeMessageInterruptedException largeMessageInterrupted();

    @Message(id=219061, value="Cannot send a packet while channel is failing over.")
    public IllegalStateException cannotSendPacketDuringFailover();

    @Message(id=219062, value="Multi-packet transmission (e.g. Large Messages) interrupted because of a reconnection.")
    public ActiveMQInterruptedException packetTransmissionInterrupted();

    @Message(id=219063, value="Cannot send a packet while response cache is full.")
    public IllegalStateException cannotSendPacketWhilstResponseCacheFull();

    @Message(id=219064, value="Invalide packet: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidPacket(byte var1);

    @Message(id=219065, value="Failed to handle packet.")
    public RuntimeException failedToHandlePacket(@Cause Exception var1);

    @Message(id=219066, value="The connection was redirected")
    public ActiveMQRoutingException redirected();

    @Message(id=219067, value="Keystore alias {0} not found in {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException keystoreAliasNotFound(String var1, String var2);
}

