/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

public class DistributedSecurityRealm
implements SecurityRealm {
    private final SecurityRealm[] securityRealms;

    public DistributedSecurityRealm(SecurityRealm ... securityRealms) {
        Assert.checkNotNullParam("securityRealms", securityRealms);
        this.securityRealms = securityRealms;
    }

    @Override
    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        return new EvidenceDistributedIdentity(evidence);
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return new PrincipalDistributedIdentity(principal);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        SupportLevel max = SupportLevel.UNSUPPORTED;
        for (SecurityRealm r : this.securityRealms) {
            max = SupportLevel.max(max, r.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec));
        }
        return max;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        SupportLevel max = SupportLevel.UNSUPPORTED;
        for (SecurityRealm r : this.securityRealms) {
            max = SupportLevel.max(max, r.getEvidenceVerifySupport(evidenceType, algorithmName));
        }
        return max;
    }

    final class PrincipalDistributedIdentity
    implements RealmIdentity {
        private final Principal principal;
        private RealmIdentity currentIdentity = RealmIdentity.NON_EXISTENT;
        private int nextRealm = 0;

        PrincipalDistributedIdentity(Principal principal) throws RealmUnavailableException {
            this.principal = principal;
            this.nextIdentity();
        }

        private boolean nextIdentity() throws RealmUnavailableException {
            this.currentIdentity.dispose();
            if (this.nextRealm >= DistributedSecurityRealm.this.securityRealms.length) {
                this.currentIdentity = RealmIdentity.NON_EXISTENT;
                return false;
            }
            this.currentIdentity = DistributedSecurityRealm.this.securityRealms[this.nextRealm].getRealmIdentity(this.principal);
            ++this.nextRealm;
            if (!this.currentIdentity.exists()) {
                return this.nextIdentity();
            }
            return true;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.currentIdentity.getRealmIdentityPrincipal();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.currentIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.currentIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            do {
                C credential;
                if ((credential = this.currentIdentity.getCredential(credentialType, algorithmName, parameterSpec)) == null) continue;
                return credential;
            } while (this.nextIdentity());
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            do {
                C credential;
                if ((credential = this.currentIdentity.getCredential(credentialType, algorithmName)) == null) continue;
                return credential;
            } while (this.nextIdentity());
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            do {
                C credential;
                if ((credential = this.currentIdentity.getCredential(credentialType)) == null) continue;
                return credential;
            } while (this.nextIdentity());
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.currentIdentity.verifyEvidence(evidence);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.currentIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.currentIdentity.getAuthorizationIdentity();
        }

        @Override
        public void dispose() {
            this.currentIdentity.dispose();
        }
    }

    final class EvidenceDistributedIdentity
    implements RealmIdentity {
        private final Evidence evidence;
        private final String evidenceAlgorithm;
        private RealmIdentity currentIdentity = RealmIdentity.NON_EXISTENT;
        private int nextRealm = 0;

        private EvidenceDistributedIdentity(Evidence evidence) throws RealmUnavailableException {
            this.evidence = evidence;
            this.evidenceAlgorithm = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            this.nextIdentity();
        }

        private boolean nextIdentity() throws RealmUnavailableException {
            this.currentIdentity.dispose();
            if (this.nextRealm >= DistributedSecurityRealm.this.securityRealms.length) {
                this.currentIdentity = RealmIdentity.NON_EXISTENT;
                return false;
            }
            if (DistributedSecurityRealm.this.securityRealms[this.nextRealm].getEvidenceVerifySupport(this.evidence.getClass(), this.evidenceAlgorithm).mayBeSupported()) {
                this.currentIdentity = DistributedSecurityRealm.this.securityRealms[this.nextRealm].getRealmIdentity(this.evidence);
                ++this.nextRealm;
                if (this.currentIdentity.getEvidenceVerifySupport(this.evidence.getClass(), this.evidenceAlgorithm).isNotSupported()) {
                    return this.nextIdentity();
                }
            } else {
                ++this.nextRealm;
                return this.nextIdentity();
            }
            return true;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return this.currentIdentity.getRealmIdentityPrincipal();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.currentIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            do {
                if (!this.currentIdentity.verifyEvidence(evidence)) continue;
                return true;
            } while (this.nextIdentity());
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.currentIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.currentIdentity.getAuthorizationIdentity();
        }

        @Override
        public void dispose() {
            this.currentIdentity.dispose();
        }
    }
}

