package org.jboss.as.service.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.xml.namespace.QName;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.jboss.as.server.deployment.DeploymentUnit;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-08-15T16:08:15-0700")
public class SarLogger_$logger extends DelegatingBasicLogger implements SarLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SarLogger_$logger.class.getName();
    public SarLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String failedExecutingLegacyMethod = "WFLYSAR0001: Failed to execute legacy service %s method";
    protected String failedExecutingLegacyMethod$str() {
        return failedExecutingLegacyMethod;
    }
    @Override
    public final String failedExecutingLegacyMethod(final String methodName) {
        return String.format(getLoggingLocale(), failedExecutingLegacyMethod$str(), methodName);
    }
    @Override
    public final void propertyNotFound(final Class<?> type) {
        super.log.logf(FQCN, WARN, null, propertyNotFound$str(), type);
    }
    private static final String propertyNotFound = "WFLYSAR0002: Unable to find PropertyEditor for type %s";
    protected String propertyNotFound$str() {
        return propertyNotFound;
    }
    private static final String classNotFound = "WFLYSAR0003: Class not found";
    protected String classNotFound$str() {
        return classNotFound;
    }
    @Override
    public final IllegalArgumentException classNotFound(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), classNotFound$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classNotInstantiated = "WFLYSAR0004: Class not instantiated";
    protected String classNotInstantiated$str() {
        return classNotInstantiated;
    }
    @Override
    public final IllegalArgumentException classNotInstantiated(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), classNotInstantiated$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetAttachment = "WFLYSAR0005: Failed to get %s attachment for %s";
    protected String failedToGetAttachment$str() {
        return failedToGetAttachment;
    }
    @Override
    public final DeploymentUnitProcessingException failedToGetAttachment(final String attachmentType, final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToGetAttachment$str(), attachmentType, deploymentUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedXmlParsing = "WFLYSAR0006: Failed to parse service xml [%s]";
    protected String failedXmlParsing$str() {
        return failedXmlParsing;
    }
    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(final VirtualFile xmlFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedXmlParsing$str(), xmlFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(final Throwable cause, final VirtualFile xmlFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedXmlParsing$str(), xmlFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotFound = "WFLYSAR0007: Method '%s(%s)' not found for: %s";
    protected String methodNotFound$str() {
        return methodNotFound;
    }
    @Override
    public final IllegalStateException methodNotFound(final String methodName, final String methodParams, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), methodNotFound$str(), methodName, methodParams, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredAttributes = "WFLYSAR0008: Missing one or more required attributes:";
    protected String missingRequiredAttributes$str() {
        return missingRequiredAttributes;
    }
    @Override
    public final String missingRequiredAttributes() {
        return String.format(getLoggingLocale(), missingRequiredAttributes$str());
    }
    private static final String nullVar = "WFLYSAR0009: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullVar$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyMethodNotFound = "WFLYSAR0010: %s method for property '%s' not found for: %s";
    protected String propertyMethodNotFound$str() {
        return propertyMethodNotFound;
    }
    @Override
    public final IllegalStateException propertyMethodNotFound(final String methodPrefix, final String propertyName, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), propertyMethodNotFound$str(), methodPrefix, propertyName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedContent = "WFLYSAR0011: Unexpected content of type '%s' named '%s', text is: %s";
    protected String unexpectedContent$str() {
        return unexpectedContent;
    }
    @Override
    public final String unexpectedContent(final String kind, final QName name, final String text) {
        return String.format(getLoggingLocale(), unexpectedContent$str(), kind, name, text);
    }
    private static final String failedToProcessSarChild = "WFLYSAR0012: Failed to process SAR child archives for [%s]";
    protected String failedToProcessSarChild$str() {
        return failedToProcessSarChild;
    }
    @Override
    public final DeploymentUnitProcessingException failedToProcessSarChild(final Throwable cause, final VirtualFile deploymentRoot) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToProcessSarChild$str(), deploymentRoot), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String malformedDependencyName = "WFLYSAR0013: Malformed dependency name %s";
    protected String malformedDependencyName$str() {
        return malformedDependencyName;
    }
    @Override
    public final DeploymentUnitProcessingException malformedDependencyName(final Throwable cause, final String dependencyName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), malformedDependencyName$str(), dependencyName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultConstructorNotFound = "WFLYSAR0014: Could not find default constructor for %s";
    protected String defaultConstructorNotFound$str() {
        return defaultConstructorNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFound(final Class<?> clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), defaultConstructorNotFound$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
