/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.component;

import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ServiceComponentInstantiator {
    private volatile BasicComponent component;
    private final ServiceRegistry serviceRegistry;
    private final ServiceName componentStartServiceName;

    public ServiceComponentInstantiator(DeploymentUnit deploymentUnit, ComponentDescription componentDescription) {
        this.componentStartServiceName = componentDescription.getStartServiceName();
        this.serviceRegistry = deploymentUnit.getServiceRegistry();
    }

    public ServiceName getComponentStartServiceName() {
        return this.componentStartServiceName;
    }

    private synchronized void setupComponent() {
        if (this.component == null) {
            this.component = (BasicComponent)this.serviceRegistry.getRequiredService(this.componentStartServiceName).getValue();
        }
    }

    public ManagedReference initializeInstance(final Object instance) {
        this.setupComponent();
        return new ManagedReference(){
            private final ComponentInstance componentInstance;
            private boolean destroyed;
            {
                this.componentInstance = ServiceComponentInstantiator.this.component.createInstance(instance);
            }

            public synchronized void release() {
                if (!this.destroyed) {
                    this.componentInstance.destroy();
                    this.destroyed = true;
                }
            }

            public Object getInstance() {
                return this.componentInstance.getInstance();
            }
        };
    }
}

