/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.RawPassword;

class RawOneTimePassword
extends RawPassword
implements OneTimePassword {
    private static final long serialVersionUID = -5742928998692812041L;
    private final byte[] hash;
    private final byte[] seed;
    private final int sequenceNumber;

    RawOneTimePassword(String algorithm, byte[] hash, byte[] seed, int sequenceNumber) {
        super(algorithm);
        this.hash = hash;
        this.seed = seed;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public RawOneTimePassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Arrays.hashCode(this.seed)), this.sequenceNumber), this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawOneTimePassword)) {
            return false;
        }
        RawOneTimePassword other = (RawOneTimePassword)obj;
        return this.sequenceNumber == other.sequenceNumber && this.getAlgorithm().equals(other.getAlgorithm()) && Arrays.equals(this.hash, other.hash) && Arrays.equals(this.seed, other.seed);
    }
}

