/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.wildfly.security.ssl.AndCipherSuitePredicate;
import org.wildfly.security.ssl.Authentication;
import org.wildfly.security.ssl.AuthenticationCipherSuitePredicate;
import org.wildfly.security.ssl.BooleanCipherSuitePredicate;
import org.wildfly.security.ssl.Digest;
import org.wildfly.security.ssl.DigestCipherSuitePredicate;
import org.wildfly.security.ssl.Encryption;
import org.wildfly.security.ssl.EncryptionCipherSuitePredicate;
import org.wildfly.security.ssl.ExportCipherSuitePredicate;
import org.wildfly.security.ssl.FipsCipherSuitePredicate;
import org.wildfly.security.ssl.KeyAgreement;
import org.wildfly.security.ssl.KeyAgreementCipherSuitePredicate;
import org.wildfly.security.ssl.LevelCipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;
import org.wildfly.security.ssl.NotCipherSuitePredicate;
import org.wildfly.security.ssl.OrCipherSuitePredicate;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolCipherSuitePredicate;
import org.wildfly.security.ssl.SecurityLevel;

public abstract class CipherSuitePredicate {
    private static final CipherSuitePredicate DEFAULTS_PREDICATE = CipherSuitePredicate.matchAny(CipherSuitePredicate.matchEncryption(Encryption.RC2, Encryption.RC4, Encryption.NULL), CipherSuitePredicate.matchAuthentication(Authentication.NULL));
    private static final CipherSuitePredicate ANON_DH_PREDICATE = CipherSuitePredicate.matchAll(CipherSuitePredicate.matchKeyExchange(KeyAgreement.DHd, KeyAgreement.DHr, KeyAgreement.DHE), CipherSuitePredicate.matchAuthentication(Authentication.NULL));
    private static final CipherSuitePredicate OPENSSL_COMPLEMENT_OF_ALL = CipherSuitePredicate.matchEncryption(Encryption.NULL);
    private static final CipherSuitePredicate OPENSSL_DEFAULT_DELETES = CipherSuitePredicate.matchAny(CipherSuitePredicate.matchAuthentication(Authentication.NULL), CipherSuitePredicate.matchEncryption(Encryption.NULL));
    private static final CipherSuitePredicate OPENSSL_COMPLEMENT_OF_DEFAULT = CipherSuitePredicate.matchAll(CipherSuitePredicate.matchAuthentication(Authentication.NULL), CipherSuitePredicate.matchNot(CipherSuitePredicate.matchEncryption(Encryption.NULL)));
    private static final CipherSuitePredicate OPENSSL_ALL = CipherSuitePredicate.matchNot(OPENSSL_COMPLEMENT_OF_ALL);

    static CipherSuitePredicate optimize(CipherSuitePredicate predicate) {
        return predicate.isAlwaysFalse() ? CipherSuitePredicate.matchFalse() : (predicate.isAlwaysTrue() ? CipherSuitePredicate.matchTrue() : predicate);
    }

    public static CipherSuitePredicate matchTrue() {
        return BooleanCipherSuitePredicate.TRUE;
    }

    public static CipherSuitePredicate matchFalse() {
        return BooleanCipherSuitePredicate.FALSE;
    }

    public static CipherSuitePredicate matchAll(CipherSuitePredicate ... predicates) {
        return CipherSuitePredicate.optimize(new AndCipherSuitePredicate(predicates));
    }

    public static CipherSuitePredicate matchAny(CipherSuitePredicate ... predicates) {
        return CipherSuitePredicate.optimize(new OrCipherSuitePredicate(predicates));
    }

    public static CipherSuitePredicate matchNot(CipherSuitePredicate predicate) {
        return CipherSuitePredicate.optimize(new NotCipherSuitePredicate(predicate));
    }

    static <T> T[] withoutNulls(T[] orig) {
        if (orig == null) {
            return null;
        }
        for (T item : orig) {
            if (item != null) continue;
            ArrayList<T> list = null;
            for (T item2 : orig) {
                if (item2 == null) continue;
                if (list == null) {
                    list = new ArrayList<T>(orig.length - 1);
                }
                list.add(item2);
            }
            return list == null ? null : list.toArray(Arrays.copyOf(orig, list.size()));
        }
        return orig;
    }

    public static CipherSuitePredicate matchEncryption(Encryption encryption) {
        return encryption == null ? CipherSuitePredicate.matchFalse() : new EncryptionCipherSuitePredicate(EnumSet.of(encryption));
    }

    public static CipherSuitePredicate matchEncryption(Encryption ... encryptions) {
        return (encryptions = CipherSuitePredicate.withoutNulls(encryptions)) == null || encryptions.length == 0 ? CipherSuitePredicate.matchFalse() : (encryptions.length == Encryption.fullSize ? CipherSuitePredicate.matchTrue() : new EncryptionCipherSuitePredicate(EnumSet.of(encryptions[0], encryptions)));
    }

    public static CipherSuitePredicate matchEncryption(EnumSet<Encryption> encryptions) {
        return encryptions == null || encryptions.isEmpty() ? CipherSuitePredicate.matchFalse() : (Encryption.isFull(encryptions) ? CipherSuitePredicate.matchTrue() : new EncryptionCipherSuitePredicate(encryptions));
    }

    public static CipherSuitePredicate matchAuthentication(Authentication authentication) {
        return authentication == null ? CipherSuitePredicate.matchFalse() : new AuthenticationCipherSuitePredicate(true, EnumSet.of(authentication));
    }

    public static CipherSuitePredicate matchAuthentication(Authentication ... authentications) {
        return (authentications = CipherSuitePredicate.withoutNulls(authentications)) == null || authentications.length == 0 ? CipherSuitePredicate.matchFalse() : (authentications.length == Authentication.fullSize ? CipherSuitePredicate.matchTrue() : new AuthenticationCipherSuitePredicate(true, EnumSet.of(authentications[0], authentications)));
    }

    public static CipherSuitePredicate matchAuthentication(EnumSet<Authentication> authentications) {
        return authentications == null || authentications.isEmpty() ? CipherSuitePredicate.matchFalse() : (Authentication.isFull(authentications) ? CipherSuitePredicate.matchTrue() : CipherSuitePredicate.optimize(new AuthenticationCipherSuitePredicate(true, authentications)));
    }

    public static CipherSuitePredicate matchKeyAgreement(KeyAgreement keyAgreement) {
        return keyAgreement == null ? CipherSuitePredicate.matchFalse() : new KeyAgreementCipherSuitePredicate(EnumSet.of(keyAgreement));
    }

    public static CipherSuitePredicate matchKeyExchange(KeyAgreement ... keyAgreements) {
        return (keyAgreements = CipherSuitePredicate.withoutNulls(keyAgreements)) == null || keyAgreements.length == 0 ? CipherSuitePredicate.matchFalse() : (keyAgreements.length == KeyAgreement.fullSize ? CipherSuitePredicate.matchTrue() : new KeyAgreementCipherSuitePredicate(EnumSet.of(keyAgreements[0], keyAgreements)));
    }

    public static CipherSuitePredicate matchKeyExchange(EnumSet<KeyAgreement> keyAgreements) {
        return keyAgreements == null || keyAgreements.isEmpty() ? CipherSuitePredicate.matchFalse() : (KeyAgreement.isFull(keyAgreements) ? CipherSuitePredicate.matchTrue() : new KeyAgreementCipherSuitePredicate(keyAgreements));
    }

    public static CipherSuitePredicate matchDigest(Digest digest) {
        return digest == null ? CipherSuitePredicate.matchFalse() : new DigestCipherSuitePredicate(EnumSet.of(digest));
    }

    public static CipherSuitePredicate matchDigest(Digest ... digests) {
        return (digests = CipherSuitePredicate.withoutNulls(digests)) == null || digests.length == 0 ? CipherSuitePredicate.matchFalse() : (digests.length == Digest.fullSize ? CipherSuitePredicate.matchTrue() : new DigestCipherSuitePredicate(EnumSet.of(digests[0], digests)));
    }

    public static CipherSuitePredicate matchDigest(EnumSet<Digest> digests) {
        return digests == null || digests.isEmpty() ? CipherSuitePredicate.matchFalse() : (Digest.isFull(digests) ? CipherSuitePredicate.matchTrue() : new DigestCipherSuitePredicate(digests));
    }

    public static CipherSuitePredicate matchProtocol(Protocol protocol) {
        return protocol == null ? CipherSuitePredicate.matchFalse() : new ProtocolCipherSuitePredicate(EnumSet.of(protocol));
    }

    public static CipherSuitePredicate matchProtocol(Protocol ... protocols) {
        return (protocols = CipherSuitePredicate.withoutNulls(protocols)) == null || protocols.length == 0 ? CipherSuitePredicate.matchFalse() : (protocols.length == Protocol.fullSize ? CipherSuitePredicate.matchTrue() : new ProtocolCipherSuitePredicate(EnumSet.of(protocols[0], protocols)));
    }

    public static CipherSuitePredicate matchProtocol(EnumSet<Protocol> protocols) {
        return protocols == null || protocols.isEmpty() ? CipherSuitePredicate.matchFalse() : (Protocol.isFull(protocols) ? CipherSuitePredicate.matchTrue() : new ProtocolCipherSuitePredicate(protocols));
    }

    public static CipherSuitePredicate matchLevel(SecurityLevel level) {
        return level == null ? CipherSuitePredicate.matchFalse() : new LevelCipherSuitePredicate(EnumSet.of(level));
    }

    public static CipherSuitePredicate matchLevel(SecurityLevel ... levels) {
        return (levels = CipherSuitePredicate.withoutNulls(levels)) == null || levels.length == 0 ? CipherSuitePredicate.matchFalse() : (levels.length == SecurityLevel.fullSize ? CipherSuitePredicate.matchTrue() : new LevelCipherSuitePredicate(EnumSet.of(levels[0], levels)));
    }

    public static CipherSuitePredicate matchLevel(EnumSet<SecurityLevel> levels) {
        return levels == null || levels.isEmpty() ? CipherSuitePredicate.matchFalse() : (SecurityLevel.isFull(levels) ? CipherSuitePredicate.matchTrue() : new LevelCipherSuitePredicate(levels));
    }

    public static CipherSuitePredicate matchLevelLessThan(final SecurityLevel level) {
        return level == null || level == SecurityLevel.NONE ? CipherSuitePredicate.matchFalse() : new CipherSuitePredicate(){

            @Override
            void toString(StringBuilder b) {
                b.append("security level is less than ").append((Object)level);
            }

            @Override
            boolean test(MechanismDatabase.Entry entry) {
                return entry.getLevel().compareTo(level) < 0;
            }
        };
    }

    public static CipherSuitePredicate matchFips() {
        return FipsCipherSuitePredicate.TRUE;
    }

    public static CipherSuitePredicate matchNonFips() {
        return FipsCipherSuitePredicate.FALSE;
    }

    public static CipherSuitePredicate matchExport() {
        return ExportCipherSuitePredicate.TRUE;
    }

    public static CipherSuitePredicate matchNonExport() {
        return ExportCipherSuitePredicate.FALSE;
    }

    public static CipherSuitePredicate matchName(final String name) {
        return name == null ? CipherSuitePredicate.matchFalse() : new CipherSuitePredicate(){

            @Override
            void toString(StringBuilder b) {
                b.append("cipher name is \"").append(name).append("\"");
            }

            @Override
            boolean test(MechanismDatabase.Entry entry) {
                return entry.getOpenSslName().equals(name) || entry.getAliases().contains(name) || entry.getName().equals(name);
            }
        };
    }

    public static CipherSuitePredicate matchDefaultDeletes() {
        return DEFAULTS_PREDICATE;
    }

    public static CipherSuitePredicate matchAnonDH() {
        return ANON_DH_PREDICATE;
    }

    public static CipherSuitePredicate matchOpenSslAll() {
        return OPENSSL_ALL;
    }

    public static CipherSuitePredicate matchOpenSslComplementOfAll() {
        return OPENSSL_COMPLEMENT_OF_ALL;
    }

    public static CipherSuitePredicate matchOpenSslDefaultDeletes() {
        return OPENSSL_DEFAULT_DELETES;
    }

    public static CipherSuitePredicate matchOpenSslComplementOfDefault() {
        return OPENSSL_COMPLEMENT_OF_DEFAULT;
    }

    abstract void toString(StringBuilder var1);

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    abstract boolean test(MechanismDatabase.Entry var1);

    boolean isAlwaysTrue() {
        return false;
    }

    boolean isAlwaysFalse() {
        return false;
    }
}

