/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.apache.commons.lang3.ObjectUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.CredentialReference;
import org.wildfly.test.security.common.elytron.KeyStore;
import org.wildfly.test.security.common.elytron.Path;

public class SimpleKeyStore
extends AbstractConfigurableElement
implements KeyStore {
    private final Path path;
    private final CredentialReference credentialReference;
    private final String type;
    private final boolean required;

    private SimpleKeyStore(Builder builder) {
        super(builder);
        this.path = (Path)ObjectUtils.defaultIfNull((Object)builder.path, (Object)Path.EMPTY);
        this.credentialReference = (CredentialReference)ObjectUtils.defaultIfNull((Object)builder.credentialReference, (Object)CredentialReference.EMPTY);
        this.type = (String)ObjectUtils.defaultIfNull((Object)builder.type, (Object)"JKS");
        this.required = builder.required;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/key-store=%s:add(%s%stype=\"%s\",required=%s)", this.name, this.path.asString(), this.credentialReference.asString(), this.type, Boolean.toString(this.required)));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/key-store=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private Path path;
        private CredentialReference credentialReference;
        private String type;
        private boolean required;

        private Builder() {
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withCredentialReference(CredentialReference credentialReference) {
            this.credentialReference = credentialReference;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public SimpleKeyStore build() {
            return new SimpleKeyStore(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

