/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.interfaces;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.test.integration.management.interfaces.JmxInterfaceStringUtils;
import org.jboss.as.test.integration.management.interfaces.ManagementInterface;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class JmxManagementInterface
implements ManagementInterface {
    private final JMXConnector jmxConnector;
    private final String domain;

    protected JmxManagementInterface(JMXConnector jmxConnector, String domain) {
        this.jmxConnector = jmxConnector;
        this.domain = domain;
    }

    @Override
    public void close() {
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public ModelNode execute(ModelNode operation) {
        try {
            ObjectName objectName = this.objectName(operation);
            return this.doExecute(objectName, operation);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode doExecute(ObjectName objectName, ModelNode op) {
        String opName = op.get("operation").asString();
        if ("read-attribute".equals(opName)) {
            String name = JmxInterfaceStringUtils.toCamelCase(op.get("name").asString());
            return this.getAttribute(objectName, name);
        }
        if ("write-attribute".equals(opName)) {
            String name = JmxInterfaceStringUtils.toCamelCase(op.get("name").asString());
            Object value = JmxManagementInterface.object(op.get("value"));
            return this.setAttribute(objectName, name, value);
        }
        if ("read-resource".equals(opName)) {
            return this.getInfo(objectName);
        }
        HashSet keys = new HashSet(op.keys());
        keys.remove("operation");
        keys.remove("address");
        if (!keys.isEmpty()) {
            throw new UnsupportedOperationException("Operations with arguments are not supported: " + opName + " " + keys);
        }
        String name = JmxInterfaceStringUtils.toCamelCase(op.get("operation").asString());
        return this.invoke(objectName, name);
    }

    private ModelNode getAttribute(ObjectName objectName, String name) {
        MBeanServerConnection connection = this.getConnection();
        Object result = null;
        JMRuntimeException exception = null;
        try {
            result = connection.getAttribute(objectName, name);
        }
        catch (JMRuntimeException e) {
            exception = e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.modelNodeResult(result, exception);
    }

    private ModelNode setAttribute(ObjectName objectName, String name, Object value) {
        MBeanServerConnection connection = this.getConnection();
        Attribute attribute = new Attribute(name, value);
        JMRuntimeException exception = null;
        try {
            connection.setAttribute(objectName, attribute);
        }
        catch (JMRuntimeException e) {
            exception = e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.modelNodeResult(null, exception);
    }

    private ModelNode invoke(ObjectName objectName, String name) {
        MBeanServerConnection connection = this.getConnection();
        Object result = null;
        JMRuntimeException exception = null;
        try {
            result = connection.invoke(objectName, name, null, null);
        }
        catch (JMRuntimeException e) {
            exception = e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.modelNodeResult(result, exception);
    }

    private ModelNode getInfo(ObjectName objectName) {
        MBeanServerConnection connection = this.getConnection();
        ModelNode attributes = null;
        ModelNode headers = null;
        Exception exception = null;
        try {
            MBeanInfo mBeanInfo = connection.getMBeanInfo(objectName);
            MBeanAttributeInfo[] attributeInfos = mBeanInfo.getAttributes();
            ModelNode[] data = this.modelNodeAttributesInfo(attributeInfos, objectName);
            attributes = data[0];
            headers = data[1];
        }
        catch (Exception e) {
            if (e instanceof JMException || e instanceof JMRuntimeException) {
                exception = e;
            }
            throw new RuntimeException(e);
        }
        return this.modelNodeResult(attributes, exception, headers);
    }

    private ModelNode[] modelNodeAttributesInfo(MBeanAttributeInfo[] attributeInfos, ObjectName objectName) throws IOException, JMException {
        MBeanServerConnection connection = this.getConnection();
        ModelNode attributes = new ModelNode();
        ModelNode filtered = new ModelNode().setEmptyList();
        ModelNode headers = null;
        for (MBeanAttributeInfo attribute : attributeInfos) {
            String attributeName = attribute.getName();
            try {
                Object attributeValue = connection.getAttribute(objectName, attributeName);
                try {
                    attributes.get(JmxInterfaceStringUtils.toDashCase(attributeName)).set(JmxManagementInterface.modelNode(attributeValue));
                }
                catch (UnsupportedOperationException e) {}
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message.contains("14807") || message.contains("14883")) {
                    throw e;
                }
                if (message.contains("13456") || message.contains("11362")) {
                    filtered.add(JmxInterfaceStringUtils.toDashCase(attributeName));
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
        if (!filtered.asList().isEmpty()) {
            headers = new ModelNode();
            headers.get(new String[]{"access-control", "filtered-attributes"}).set(filtered);
        }
        return new ModelNode[]{attributes, headers};
    }

    private ModelNode modelNodeResult(Object result, Exception exception) {
        return this.modelNodeResult(result, exception, null);
    }

    private ModelNode modelNodeResult(Object result, Exception exception, ModelNode headers) {
        ModelNode root = new ModelNode();
        if (exception == null) {
            root.get("outcome").set("success");
            if (result != null) {
                root.get("result").set(JmxManagementInterface.modelNode(result));
            }
        } else {
            root.get("outcome").set("failed");
            root.get("failure-description").set(JmxInterfaceStringUtils.rawString(exception.getMessage()));
            if (result != null) {
                root.get("result").set(JmxManagementInterface.modelNode(result));
            }
        }
        if (headers != null) {
            root.get("response-headers").set(headers);
        }
        return root;
    }

    private static ModelNode modelNode(Object obj) {
        if (obj == null) {
            return new ModelNode();
        }
        if (obj instanceof ModelNode) {
            return (ModelNode)obj;
        }
        if (obj instanceof BigDecimal) {
            return new ModelNode((BigDecimal)obj);
        }
        if (obj instanceof BigInteger) {
            return new ModelNode((BigInteger)obj);
        }
        if (obj instanceof Boolean) {
            return new ModelNode(((Boolean)obj).booleanValue());
        }
        if (obj instanceof byte[]) {
            return new ModelNode((byte[])obj);
        }
        if (obj instanceof Double) {
            return new ModelNode(((Double)obj).doubleValue());
        }
        if (obj instanceof Integer) {
            return new ModelNode(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new ModelNode(((Long)obj).longValue());
        }
        if (obj instanceof String) {
            return JmxInterfaceStringUtils.nodeFromString((String)obj);
        }
        throw new UnsupportedOperationException("Can't convert '" + obj.getClass() + "' to ModelNode: " + obj);
    }

    private static Object object(ModelNode node) {
        switch (node.getType()) {
            case BIG_DECIMAL: {
                return node.asBigDecimal();
            }
            case BIG_INTEGER: {
                return node.asBigInteger();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case BYTES: {
                return node.asBytes();
            }
            case DOUBLE: {
                return node.asDouble();
            }
            case EXPRESSION: {
                return node.asExpression();
            }
            case INT: {
                return node.asInt();
            }
            case LIST: {
                return node.asList();
            }
            case LONG: {
                return node.asLong();
            }
            case PROPERTY: {
                return node.asProperty();
            }
            case STRING: {
                return node.asString();
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Can't convert '" + node.getType() + "' to object");
    }

    private ObjectName objectName(ModelNode operation) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder();
        String opName = operation.get("operation").asString();
        if (operation.has("address")) {
            ModelNode address = operation.get("address");
            Iterator it = address.asList().iterator();
            while (it.hasNext()) {
                Property segment = ((ModelNode)it.next()).asProperty();
                if (opName.equals("add") && !it.hasNext()) continue;
                builder.append(segment.getName()).append("=").append(segment.getValue().asString()).append(",");
            }
        }
        if (builder.toString().isEmpty()) {
            builder.append("management-root=server,");
        }
        builder.deleteCharAt(builder.length() - 1);
        return new ObjectName(this.domain + ":" + builder.toString());
    }

    public MBeanServerConnection getConnection() {
        MBeanServerConnection mBeanServerConnection = null;
        try {
            mBeanServerConnection = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mBeanServerConnection;
    }

    public static JmxManagementInterface create(JMXServiceURL url, String username, String password, String domain) {
        try {
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            env.put("jmx.remote.credentials", new String[]{username, password});
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, env);
            return new JmxManagementInterface(jmxConnector, domain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

