/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CLIOpResult {
    private ModelNode responseNode;
    private boolean isOutcomeSuccess;
    private Map<String, Object> responseMap;

    public CLIOpResult() {
    }

    public CLIOpResult(ModelNode node) {
        this.responseNode = node;
        this.responseMap = this.toMap(node);
        this.isOutcomeSuccess = "success".equals(this.responseMap.get("outcome"));
    }

    protected Map<String, Object> toMap(ModelNode node) {
        Set keys = node.keys();
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            map.put(key, this.toObject(node.get(key)));
        }
        return map;
    }

    protected List<Object> toList(ModelNode node) {
        List nodeList = node.asList();
        ArrayList<Object> list = new ArrayList<Object>(nodeList.size());
        for (ModelNode item : nodeList) {
            list.add(this.toObject(item));
        }
        return list;
    }

    protected Object toObject(ModelNode node) {
        ModelType type = node.getType();
        if (type.equals((Object)ModelType.LIST)) {
            return this.toList(node);
        }
        if (type.equals((Object)ModelType.OBJECT)) {
            return this.toMap(node);
        }
        if (type.equals((Object)ModelType.PROPERTY)) {
            Property prop = node.asProperty();
            return Collections.singletonMap(prop.getName(), this.toObject(prop.getValue()));
        }
        return node.asString();
    }

    public boolean isIsOutcomeSuccess() {
        return this.isOutcomeSuccess;
    }

    public Object getResult() {
        return this.getFromResponse("result");
    }

    public ModelNode getResponseNode() {
        return this.responseNode;
    }

    public Map<String, Object> getResultAsMap() {
        Object result = this.getResult();
        return (Map)(result instanceof Map ? result : null);
    }

    public Object getNamedResult(String key) {
        Map<String, Object> map = this.getResultAsMap();
        return map != null ? map.get(key) : null;
    }

    public Map<String, Object> getNamedResultAsMap(String key) {
        Object value = this.getNamedResult(key);
        return (Map)(value instanceof Map ? value : null);
    }

    public Object getServerGroups() {
        return this.getFromResponse("server-groups");
    }

    public Object getFromResponse(String key) {
        return this.responseMap.get(key);
    }
}

