/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.extension.undertow.Host;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

class HttpInvokerHostService
implements Service<HttpInvokerHostService> {
    private final String path;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<HttpAuthenticationFactory> httpAuthenticationFactoryInjectedValue = new InjectedValue();
    private final InjectedValue<PathHandler> remoteHttpInvokerServiceInjectedValue = new InjectedValue();

    public HttpInvokerHostService(String path) {
        this.path = path;
    }

    public void start(StartContext startContext) throws StartException {
        HttpHandler handler = (HttpHandler)this.remoteHttpInvokerServiceInjectedValue.getValue();
        if (this.httpAuthenticationFactoryInjectedValue.getOptionalValue() != null) {
            handler = HttpInvokerHostService.secureAccess(handler, (HttpAuthenticationFactory)this.httpAuthenticationFactoryInjectedValue.getOptionalValue());
        }
        ((Host)this.host.getValue()).registerHandler(this.path, handler);
        ((Host)this.host.getValue()).registerModClusterPath(this.path);
    }

    public void stop(StopContext stopContext) {
        ((Host)this.host.getValue()).unregisterHandler(this.path);
        ((Host)this.host.getValue()).unregisterModClusterPath(this.path);
    }

    private static HttpHandler secureAccess(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        domainHandler = new AuthenticationCallHandler(domainHandler);
        domainHandler = new AuthenticationConstraintHandler(domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext(domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange;
                super(x0);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }

    public HttpInvokerHostService getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public InjectedValue<HttpAuthenticationFactory> getHttpAuthenticationFactoryInjectedValue() {
        return this.httpAuthenticationFactoryInjectedValue;
    }

    public InjectedValue<PathHandler> getRemoteHttpInvokerServiceInjectedValue() {
        return this.remoteHttpInvokerServiceInjectedValue;
    }
}

