/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.deployment.ImmediateSessionManagerFactory;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilder;
import org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilderValue;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilderValue;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;
import org.wildfly.extension.undertow.session.SimpleDistributableSessionManagerConfiguration;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecService;

public class SharedSessionManagerDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SharedSessionManagerConfig sharedConfig = (SharedSessionManagerConfig)deploymentUnit.getAttachment(UndertowAttachments.SHARED_SESSION_MANAGER_CONFIG);
        if (sharedConfig == null) {
            return;
        }
        ServiceTarget target = phaseContext.getServiceTarget();
        ServiceName deploymentServiceName = deploymentUnit.getServiceName();
        ServiceName managerServiceName = deploymentServiceName.append(SharedSessionManagerConfig.SHARED_SESSION_MANAGER_SERVICE_NAME);
        DistributableSessionManagerFactoryBuilder builder = new DistributableSessionManagerFactoryBuilderValue().getValue();
        if (builder != null) {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            builder.build(support, target, managerServiceName, new SimpleDistributableSessionManagerConfiguration(sharedConfig, deploymentUnit.getName(), module)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            InMemorySessionManager manager = new InMemorySessionManager(deploymentUnit.getName(), sharedConfig.getMaxActiveSessions());
            if (sharedConfig.getSessionConfig() != null && sharedConfig.getSessionConfig().getSessionTimeoutSet()) {
                manager.setDefaultSessionTimeout(sharedConfig.getSessionConfig().getSessionTimeout());
            }
            ImmediateSessionManagerFactory factory = new ImmediateSessionManagerFactory((SessionManager)manager);
            target.addService(managerServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)factory))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        ServiceName codecServiceName = deploymentServiceName.append(SharedSessionManagerConfig.SHARED_SESSION_IDENTIFIER_CODEC_SERVICE_NAME);
        DistributableSessionIdentifierCodecBuilder sessionIdentifierCodecBuilder = new DistributableSessionIdentifierCodecBuilderValue().getValue();
        if (sessionIdentifierCodecBuilder != null) {
            sessionIdentifierCodecBuilder.build(target, codecServiceName, deploymentUnit.getName()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            SimpleSessionIdentifierCodecService.build(target, codecServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

