/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.handlers.HandlerService;

final class HandlerAdd
extends AbstractAddStepHandler {
    private Handler handler;

    HandlerAdd(Handler handler) {
        super(handler.getAttributes());
        this.handler = handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        RuntimeCapability newCapability = Handler.CAPABILITY.fromBaseCapability(context.getCurrentAddress());
        boolean capabilityAvailable = context.hasOptionalCapability("org.wildfly.request-controller", newCapability.getName(), null);
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(Handler.CAPABILITY);
        Consumer hhConsumer = sb.provides(new RuntimeCapability[]{Handler.CAPABILITY});
        Supplier rcSupplier = capabilityAvailable ? sb.requiresCapability("org.wildfly.request-controller", RequestController.class, new String[0]) : null;
        sb.setInstance((Service)new HandlerService(hhConsumer, rcSupplier, this.handler.createHandler(context, model), name));
        sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
        sb.install();
    }
}

