/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Reflections;
import org.jboss.modules.Module;
import org.jboss.vfs.VFSUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    private final String buildCompatExtensionName = "jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    private static final String BUILD_COMPATIBLE_EXTENSION_CLASS_NAME = "org.jboss.weld.lite.extension.translator.LiteExtensionTranslator";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.loadAttachments(module, deploymentUnit, extensions);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
        }
    }

    private void loadAttachments(Module module, DeploymentUnit deploymentUnit, WeldPortableExtensions extensions) throws DeploymentUnitProcessingException {
        block4: {
            try {
                Extension extension;
                List<String> portableExtensionServices = this.loadServices(module, Extension.class.getName());
                List<String> buildCompatibleExtensionServices = this.loadServices(module, "jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension");
                List<Class<? extends Object>> loadedPortableExtensions = this.loadExtensions(module, portableExtensionServices);
                this.registerPortableExtensions(deploymentUnit, extensions, loadedPortableExtensions);
                List<Class<? extends Object>> loadedBuildCompatExtensions = this.loadExtensions(module, buildCompatibleExtensionServices);
                if (loadedBuildCompatExtensions.isEmpty()) break block4;
                DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
                Class loadedClass = Reflections.loadClass((String)BUILD_COMPATIBLE_EXTENSION_CLASS_NAME, (ClassLoader)module.getClassLoader());
                try {
                    extension = (Extension)loadedClass.getConstructor(List.class, ClassLoader.class).newInstance(loadedBuildCompatExtensions, module.getClassLoader());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                extensions.registerExtensionInstance(extension, deploymentUnit);
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
    }

    private List<Class<? extends Object>> loadExtensions(Module module, List<String> services) {
        ArrayList<Class<? extends Object>> result = new ArrayList<Class<? extends Object>>();
        for (String service : services) {
            Class<? extends Object> extensionClass = this.loadExtension(service, (ClassLoader)module.getClassLoader());
            if (extensionClass == null) continue;
            result.add(extensionClass);
        }
        return result;
    }

    private void registerPortableExtensions(DeploymentUnit deploymentUnit, WeldPortableExtensions extensions, Collection<Class<? extends Object>> loadedExtensions) throws DeploymentUnitProcessingException {
        for (Class<? extends Object> loadedExtension : loadedExtensions) {
            extensions.tryRegisterExtension(loadedExtension, deploymentUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadServices(Module module, String resourceSuffix) throws IOException {
        Enumeration resources = module.getClassLoader().getResources("META-INF/services/" + resourceSuffix);
        ArrayList<String> services = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = (URL)resources.nextElement();
            InputStream stream = resource.openStream();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    int commentIdx = line.indexOf(35);
                    String className = commentIdx == -1 ? line.trim() : line.substring(0, commentIdx).trim();
                    if (className.length() == 0) continue;
                    services.add(className);
                }
            }
            finally {
                VFSUtils.safeClose((Closeable)stream);
            }
        }
        return services;
    }

    private Class<? extends Object> loadExtension(String serviceClassName, ClassLoader loader) {
        try {
            return loader.loadClass(serviceClassName);
        }
        catch (Exception e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, (Throwable)e);
        }
        catch (LinkageError e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, (Throwable)e);
        }
        return null;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            deploymentUnit.removeAttachment(WeldPortableExtensions.ATTACHMENT_KEY);
        }
    }
}

