/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.ejb.SerializedStatefulSessionObject;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;

public class StatefulSessionObjectReferenceImpl
implements SessionObjectReference,
Serializable {
    private volatile boolean removed = false;
    private final Map<String, ServiceName> viewServices;
    private final ServiceName createServiceName;
    private final SessionID id;
    private final StatefulSessionComponent ejbComponent;

    public StatefulSessionObjectReferenceImpl(SessionID id, ServiceName createServiceName, Map<String, ServiceName> viewServices) {
        this.id = id;
        this.createServiceName = createServiceName;
        this.viewServices = viewServices;
        ServiceController controller = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(createServiceName);
        this.ejbComponent = (StatefulSessionComponent)controller.getValue();
    }

    public StatefulSessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.createServiceName = descriptor.getCreateServiceName();
        ServiceController controller = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.createServiceName);
        this.ejbComponent = (StatefulSessionComponent)controller.getValue();
        this.id = this.ejbComponent.createSession();
        this.viewServices = StatefulSessionObjectReferenceImpl.buildViews(descriptor);
    }

    private static Map<String, ServiceName> buildViews(EjbDescriptorImpl<?> descriptor) {
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        HashMap<String, Class> views = new HashMap<String, Class>();
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : descriptor.getRemoteBusinessInterfaces()) {
            views.put(businessInterfaceDescriptor.getInterface().getName(), businessInterfaceDescriptor.getInterface());
        }
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : descriptor.getLocalBusinessInterfaces()) {
            views.put(businessInterfaceDescriptor.getInterface().getName(), businessInterfaceDescriptor.getInterface());
        }
        for (Map.Entry entry : descriptor.getViewServices().entrySet()) {
            Class viewClass = (Class)entry.getKey();
            if (viewClass == null) continue;
            HashSet<Class> seen = new HashSet<Class>();
            HashSet toProcess = new HashSet();
            toProcess.add(viewClass);
            while (!toProcess.isEmpty()) {
                Iterator it = toProcess.iterator();
                Class clazz = (Class)it.next();
                it.remove();
                seen.add(clazz);
                viewServices.put(clazz.getName(), (ServiceName)entry.getValue());
                Class superclass = clazz.getSuperclass();
                if (superclass != Object.class && superclass != null && !seen.contains(superclass)) {
                    toProcess.add(superclass);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (seen.contains(iface)) continue;
                    toProcess.add(iface);
                }
            }
        }
        return viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.isRemoved()) {
            throw WeldLogger.ROOT_LOGGER.ejbHashBeenRemoved();
        }
        if (this.viewServices.containsKey(businessInterfaceType.getName())) {
            ServiceController serviceController = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            try {
                return (S)view.createInstance(Collections.singletonMap(SessionID.class, this.id)).getInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw WeldLogger.ROOT_LOGGER.viewNotFoundOnEJB(businessInterfaceType.getName(), this.ejbComponent.getComponentName());
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    protected Object writeReplace() throws IOException {
        return new SerializedStatefulSessionObject(this.createServiceName, this.id, this.viewServices);
    }

    public void remove() {
        if (!this.isRemoved()) {
            this.ejbComponent.removeSession(this.id);
            this.removed = true;
        }
    }

    public boolean isRemoved() {
        if (!this.removed) {
            return !this.ejbComponent.getCache().contains((Object)this.id);
        }
        return true;
    }
}

