/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.servlet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.xipki.http.servlet.ClientCertCache;
import org.xipki.http.servlet.HttpServlet;
import org.xipki.http.servlet.SslReverseProxyMode;

public abstract class AbstractHttpServlet
implements HttpServlet {
    @Override
    public boolean needsTlsSessionInfo() {
        return false;
    }

    protected static byte[] readContent(FullHttpRequest request) {
        ByteBuf buf = request.content();
        if (buf == null) {
            return null;
        }
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        return bytes;
    }

    protected static FullHttpResponse createOKResponse(HttpVersion version, String contentType, byte[] content) {
        return AbstractHttpServlet.createResponse(version, HttpResponseStatus.OK, contentType, content);
    }

    protected static FullHttpResponse createResponse(HttpVersion version, HttpResponseStatus status, String contentType, byte[] content) {
        DefaultFullHttpResponse resp;
        int contentLen;
        ByteBuf buf = null;
        int n = contentLen = content == null ? 0 : content.length;
        if (contentLen != 0) {
            buf = Unpooled.wrappedBuffer((byte[])content);
            resp = new DefaultFullHttpResponse(version, status, buf);
        } else {
            resp = new DefaultFullHttpResponse(version, status);
        }
        resp.headers().addInt((CharSequence)"Content-Length", contentLen);
        if (contentType != null && !contentType.isEmpty()) {
            resp.headers().add("Content-Type", (Object)contentType);
        }
        return resp;
    }

    protected static FullHttpResponse createErrorResponse(HttpVersion version, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
        resp.headers().addInt((CharSequence)"Content-Length", 0);
        return resp;
    }

    protected X509Certificate getClientCert(HttpRequest request, SSLSession sslSession, SslReverseProxyMode sslReverseProxyMode) throws IOException {
        return ClientCertCache.getTlsClientCert(request, sslSession, sslReverseProxyMode);
    }
}

