/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.servlet;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.xipki.http.servlet.SimpleLruCache;
import org.xipki.http.servlet.SslReverseProxyMode;

class ClientCertCache {
    private static CertificateFactory cf;
    private static final SimpleLruCache<String, X509Certificate> clientCerts;

    ClientCertCache() {
    }

    public static X509Certificate getTlsClientCert(HttpRequest request, SSLSession session, SslReverseProxyMode mode) throws IOException {
        String clientVerify;
        if (mode == SslReverseProxyMode.NONE || mode == null) {
            Certificate cert;
            Certificate[] certs;
            if (session == null) {
                return null;
            }
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException ex) {
                certs = null;
            }
            Certificate certificate = cert = certs == null || certs.length < 1 ? null : certs[0];
            if (cert != null) {
                return (X509Certificate)cert;
            }
        } else if (mode != SslReverseProxyMode.APACHE) {
            throw new RuntimeException("Should not reach here, unknown SslReverseProxyMode " + (Object)((Object)mode));
        }
        if ((clientVerify = request.headers().get("SSL_CLIENT_VERIFY")) == null || clientVerify.isEmpty()) {
            return null;
        }
        if (!"SUCCESS".equalsIgnoreCase(clientVerify.trim())) {
            return null;
        }
        String pemClientCert = request.headers().get("SSL_CLIENT_CERT");
        if (pemClientCert == null || pemClientCert.isEmpty()) {
            return null;
        }
        X509Certificate clientCert = clientCerts.get(pemClientCert);
        if (clientCert != null) {
            return clientCert;
        }
        try {
            String b64 = pemClientCert.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
            byte[] encoded = Base64.getDecoder().decode(b64.getBytes(CharsetUtil.US_ASCII));
            clientCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encoded));
        }
        catch (CertificateException ex) {
            throw new IOException("could not parse Certificate", ex);
        }
        clientCerts.put(pemClientCert, clientCert);
        return clientCert;
    }

    static {
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        clientCerts = new SimpleLruCache(100);
    }
}

