/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.servlet;

import java.net.URISyntaxException;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.SimpleLruCache;

public class ServletURIPool {
    private static final ServletURI SLASH_URI;
    private static SimpleLruCache<String, ServletURI> uriMap;

    private ServletURIPool() {
    }

    public static ServletURI getServletURI(String uri) throws URISyntaxException {
        if (uri == null || uri.isEmpty() || uri.equals("/")) {
            return SLASH_URI;
        }
        if (uri.length() > 50) {
            return new ServletURI(uri);
        }
        ServletURI uriObj = uriMap.get(uri);
        if (uriObj == null) {
            uriObj = new ServletURI(uri);
            uriMap.put(uri, uriObj);
        }
        return uriObj;
    }

    static {
        uriMap = new SimpleLruCache(100);
        try {
            SLASH_URI = new ServletURI("/");
        }
        catch (URISyntaxException ex) {
            throw new ExceptionInInitializerError("could not create ServletURI: " + ex.getMessage());
        }
    }
}

