/*
 * Decompiled with CFR 0.152.
 */
package ru.concerteza.util.buildnumber;

import java.io.File;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import ru.concerteza.util.buildnumber.BuildNumber;
import ru.concerteza.util.buildnumber.BuildNumberExtractor;

public class JGitBuildNumberMojo
extends AbstractMojo {
    private String revisionProperty = "git.revision";
    private String shortRevisionProperty = "git.shortRevision";
    private String branchProperty = "git.branch";
    private String tagProperty = "git.tag";
    private String parentProperty = "git.parent";
    private String commitsCountProperty = "git.commitsCount";
    private String buildnumberProperty = "git.buildnumber";
    private String commitDateProperty = "git.commitDate";
    private String javaScriptBuildnumberCallback = null;
    private boolean runOnlyAtExecutionRoot;
    private File repositoryDirectory;
    private File baseDirectory;
    private File executionRootDirectory;
    private MavenProject project;
    private MavenProject parentProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties props = this.project.getProperties();
        try {
            if (this.executionRootDirectory.equals(this.baseDirectory) || !this.runOnlyAtExecutionRoot) {
                BuildNumber bn = BuildNumberExtractor.extract((File)this.repositoryDirectory);
                props.setProperty(this.revisionProperty, bn.getRevision());
                props.setProperty(this.shortRevisionProperty, bn.getShortRevision());
                props.setProperty(this.branchProperty, bn.getBranch());
                props.setProperty(this.tagProperty, bn.getTag());
                props.setProperty(this.parentProperty, bn.getParent());
                props.setProperty(this.commitsCountProperty, bn.getCommitsCountAsString());
                props.setProperty(this.commitDateProperty, bn.getCommitDate());
                String composite = this.createBuildnumber(bn);
                props.setProperty(this.buildnumberProperty, composite);
                this.getLog().info((CharSequence)("Git info extracted, revision: '" + bn.getShortRevision() + "', branch: '" + bn.getBranch() + "', tag: '" + bn.getTag() + "', commitsCount: '" + bn.getCommitsCount() + "', commitDate: '" + bn.getCommitDate() + "', buildnumber: '" + composite + "'"));
            } else if ("pom".equals(this.parentProject.getPackaging())) {
                Properties parentProps = this.parentProject.getProperties();
                String revision = parentProps.getProperty(this.revisionProperty);
                if (null == revision) {
                    this.getLog().info((CharSequence)"Cannot extract Git info, maybe custom build with 'pl' argument is running");
                    this.fillPropsUnknown(props);
                    return;
                }
                props.setProperty(this.revisionProperty, revision);
                props.setProperty(this.shortRevisionProperty, parentProps.getProperty(this.shortRevisionProperty));
                props.setProperty(this.branchProperty, parentProps.getProperty(this.branchProperty));
                props.setProperty(this.tagProperty, parentProps.getProperty(this.tagProperty));
                props.setProperty(this.parentProperty, parentProps.getProperty(this.parentProperty));
                props.setProperty(this.commitsCountProperty, parentProps.getProperty(this.commitsCountProperty));
                props.setProperty(this.buildnumberProperty, parentProps.getProperty(this.buildnumberProperty));
                props.setProperty(this.commitDateProperty, parentProps.getProperty(this.commitDateProperty));
            } else {
                this.getLog().warn((CharSequence)"Cannot extract JGit version: something wrong with build process, we're not in parent, not in subproject!");
                this.fillPropsUnknown(props);
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            this.fillPropsUnknown(props);
        }
    }

    private void fillPropsUnknown(Properties props) {
        props.setProperty(this.revisionProperty, "UNKNOWN_REVISION");
        props.setProperty(this.shortRevisionProperty, "UNKNOWN_REVISION");
        props.setProperty(this.branchProperty, "UNKNOWN_BRANCH");
        props.setProperty(this.tagProperty, "UNKNOWN_TAG");
        props.setProperty(this.parentProperty, "UNKNOWN_PARENT");
        props.setProperty(this.commitsCountProperty, "-1");
        props.setProperty(this.buildnumberProperty, "UNKNOWN_BUILDNUMBER");
        props.setProperty(this.commitDateProperty, "UNKNOWN_COMMIT_DATE");
    }

    private String createBuildnumber(BuildNumber bn) throws ScriptException {
        if (null != this.javaScriptBuildnumberCallback) {
            return this.buildnumberFromJS(bn);
        }
        return bn.defaultBuildnumber();
    }

    private String buildnumberFromJS(BuildNumber bn) throws ScriptException {
        ScriptEngine jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        jsEngine.put("tag", bn.getTag());
        jsEngine.put("branch", bn.getBranch());
        jsEngine.put("revision", bn.getRevision());
        jsEngine.put("parent", bn.getParent());
        jsEngine.put("shortRevision", bn.getShortRevision());
        jsEngine.put("commitsCount", bn.getCommitsCount());
        jsEngine.put("commitDate", bn.getCommitDate());
        Object res = jsEngine.eval(this.javaScriptBuildnumberCallback);
        if (null == res) {
            throw new IllegalStateException("JS buildnumber callback returns null");
        }
        return res.toString();
    }
}

