/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.BasePathMapping;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;

public class GetBasePathMappingsPublisher
implements SdkPublisher<GetBasePathMappingsResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetBasePathMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBasePathMappingsPublisher(ApiGatewayAsyncClient client, GetBasePathMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBasePathMappingsPublisher(ApiGatewayAsyncClient client, GetBasePathMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBasePathMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBasePathMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BasePathMapping> items() {
        Function<GetBasePathMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetBasePathMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetBasePathMappingsResponseFetcher
    implements AsyncPageFetcher<GetBasePathMappingsResponse> {
        private GetBasePathMappingsResponseFetcher() {
        }

        public boolean hasNextPage(GetBasePathMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetBasePathMappingsResponse> nextPage(GetBasePathMappingsResponse previousPage) {
            if (previousPage == null) {
                return GetBasePathMappingsPublisher.this.client.getBasePathMappings(GetBasePathMappingsPublisher.this.firstRequest);
            }
            return GetBasePathMappingsPublisher.this.client.getBasePathMappings((GetBasePathMappingsRequest)((Object)GetBasePathMappingsPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

