/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationModelConfigsCopier;
import software.amazon.awssdk.services.bedrock.model.RAGConfig;
import software.amazon.awssdk.services.bedrock.model.RagConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationInferenceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationInferenceConfig> {
    private static final SdkField<List<EvaluationModelConfig>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(EvaluationInferenceConfig.getter(EvaluationInferenceConfig::models)).setter(EvaluationInferenceConfig.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RAGConfig>> RAG_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ragConfigs").getter(EvaluationInferenceConfig.getter(EvaluationInferenceConfig::ragConfigs)).setter(EvaluationInferenceConfig.setter(Builder::ragConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RAGConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD, RAG_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationInferenceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EvaluationModelConfig> models;
    private final List<RAGConfig> ragConfigs;
    private final Type type;

    private EvaluationInferenceConfig(BuilderImpl builder) {
        this.models = builder.models;
        this.ragConfigs = builder.ragConfigs;
        this.type = builder.type;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<EvaluationModelConfig> models() {
        return this.models;
    }

    public final boolean hasRagConfigs() {
        return this.ragConfigs != null && !(this.ragConfigs instanceof SdkAutoConstructList);
    }

    public final List<RAGConfig> ragConfigs() {
        return this.ragConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRagConfigs() ? this.ragConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfig)) {
            return false;
        }
        EvaluationInferenceConfig other = (EvaluationInferenceConfig)obj;
        return this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && this.hasRagConfigs() == other.hasRagConfigs() && Objects.equals(this.ragConfigs(), other.ragConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationInferenceConfig").add("Models", this.hasModels() ? this.models() : null).add("RagConfigs", this.hasRagConfigs() ? this.ragConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "ragConfigs": {
                return Optional.ofNullable(clazz.cast(this.ragConfigs()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationInferenceConfig fromModels(List<EvaluationModelConfig> models) {
        return (EvaluationInferenceConfig)EvaluationInferenceConfig.builder().models(models).build();
    }

    public static EvaluationInferenceConfig fromRagConfigs(List<RAGConfig> ragConfigs) {
        return (EvaluationInferenceConfig)EvaluationInferenceConfig.builder().ragConfigs(ragConfigs).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("models", MODELS_FIELD);
        map.put("ragConfigs", RAG_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInferenceConfig, T> g) {
        return obj -> g.apply((EvaluationInferenceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MODELS,
        RAG_CONFIGS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<EvaluationModelConfig> models = DefaultSdkAutoConstructList.getInstance();
        private List<RAGConfig> ragConfigs = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInferenceConfig model) {
            this.models(model.models);
            this.ragConfigs(model.ragConfigs);
        }

        public final List<EvaluationModelConfig.Builder> getModels() {
            List<EvaluationModelConfig.Builder> result = EvaluationModelConfigsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<EvaluationModelConfig.BuilderImpl> models) {
            List<EvaluationModelConfig> oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copyFromBuilder(models);
            this.handleUnionValueChange(Type.MODELS, oldValue, this.models);
        }

        @Override
        public final Builder models(Collection<EvaluationModelConfig> models) {
            List<EvaluationModelConfig> oldValue = this.models;
            this.models = EvaluationModelConfigsCopier.copy(models);
            this.handleUnionValueChange(Type.MODELS, oldValue, this.models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(EvaluationModelConfig ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<EvaluationModelConfig.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (EvaluationModelConfig)((EvaluationModelConfig.Builder)EvaluationModelConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RAGConfig.Builder> getRagConfigs() {
            List<RAGConfig.Builder> result = RagConfigsCopier.copyToBuilder(this.ragConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRagConfigs(Collection<RAGConfig.BuilderImpl> ragConfigs) {
            List<RAGConfig> oldValue = this.ragConfigs;
            this.ragConfigs = RagConfigsCopier.copyFromBuilder(ragConfigs);
            this.handleUnionValueChange(Type.RAG_CONFIGS, oldValue, this.ragConfigs);
        }

        @Override
        public final Builder ragConfigs(Collection<RAGConfig> ragConfigs) {
            List<RAGConfig> oldValue = this.ragConfigs;
            this.ragConfigs = RagConfigsCopier.copy(ragConfigs);
            this.handleUnionValueChange(Type.RAG_CONFIGS, oldValue, this.ragConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ragConfigs(RAGConfig ... ragConfigs) {
            this.ragConfigs(Arrays.asList(ragConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ragConfigs(Consumer<RAGConfig.Builder> ... ragConfigs) {
            this.ragConfigs(Stream.of(ragConfigs).map(c -> (RAGConfig)((RAGConfig.Builder)RAGConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationInferenceConfig build() {
            return new EvaluationInferenceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationInferenceConfig> {
        public Builder models(Collection<EvaluationModelConfig> var1);

        public Builder models(EvaluationModelConfig ... var1);

        public Builder models(Consumer<EvaluationModelConfig.Builder> ... var1);

        public Builder ragConfigs(Collection<RAGConfig> var1);

        public Builder ragConfigs(RAGConfig ... var1);

        public Builder ragConfigs(Consumer<RAGConfig.Builder> ... var1);
    }
}

