/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.GuardrailSummary;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest;
import software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse;

public class ListGuardrailsIterable
implements SdkIterable<ListGuardrailsResponse> {
    private final BedrockClient client;
    private final ListGuardrailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGuardrailsIterable(BedrockClient client, ListGuardrailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGuardrailsResponseFetcher();
    }

    public Iterator<ListGuardrailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GuardrailSummary> guardrails() {
        Function<ListGuardrailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.guardrails() != null) {
                return response.guardrails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGuardrailsResponseFetcher
    implements SyncPageFetcher<ListGuardrailsResponse> {
        private ListGuardrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListGuardrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGuardrailsResponse nextPage(ListGuardrailsResponse previousPage) {
            if (previousPage == null) {
                return ListGuardrailsIterable.this.client.listGuardrails(ListGuardrailsIterable.this.firstRequest);
            }
            return ListGuardrailsIterable.this.client.listGuardrails((ListGuardrailsRequest)((Object)ListGuardrailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

