/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ImportedModelSummary;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse;

public class ListImportedModelsIterable
implements SdkIterable<ListImportedModelsResponse> {
    private final BedrockClient client;
    private final ListImportedModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImportedModelsIterable(BedrockClient client, ListImportedModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImportedModelsResponseFetcher();
    }

    public Iterator<ListImportedModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportedModelSummary> modelSummaries() {
        Function<ListImportedModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelSummaries() != null) {
                return response.modelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImportedModelsResponseFetcher
    implements SyncPageFetcher<ListImportedModelsResponse> {
        private ListImportedModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportedModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImportedModelsResponse nextPage(ListImportedModelsResponse previousPage) {
            if (previousPage == null) {
                return ListImportedModelsIterable.this.client.listImportedModels(ListImportedModelsIterable.this.firstRequest);
            }
            return ListImportedModelsIterable.this.client.listImportedModels((ListImportedModelsRequest)((Object)ListImportedModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

