/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAutomatedReasoningPolicyBuildWorkflowResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, StartAutomatedReasoningPolicyBuildWorkflowResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(StartAutomatedReasoningPolicyBuildWorkflowResponse.getter(StartAutomatedReasoningPolicyBuildWorkflowResponse::policyArn)).setter(StartAutomatedReasoningPolicyBuildWorkflowResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildWorkflowId").getter(StartAutomatedReasoningPolicyBuildWorkflowResponse.getter(StartAutomatedReasoningPolicyBuildWorkflowResponse::buildWorkflowId)).setter(StartAutomatedReasoningPolicyBuildWorkflowResponse.setter(Builder::buildWorkflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildWorkflowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, BUILD_WORKFLOW_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAutomatedReasoningPolicyBuildWorkflowResponse.memberNameToFieldInitializer();
    private final String policyArn;
    private final String buildWorkflowId;

    private StartAutomatedReasoningPolicyBuildWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String buildWorkflowId() {
        return this.buildWorkflowId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildWorkflowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomatedReasoningPolicyBuildWorkflowResponse)) {
            return false;
        }
        StartAutomatedReasoningPolicyBuildWorkflowResponse other = (StartAutomatedReasoningPolicyBuildWorkflowResponse)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.buildWorkflowId(), other.buildWorkflowId());
    }

    public final String toString() {
        return ToString.builder((String)"StartAutomatedReasoningPolicyBuildWorkflowResponse").add("PolicyArn", (Object)this.policyArn()).add("BuildWorkflowId", (Object)this.buildWorkflowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "buildWorkflowId": {
                return Optional.ofNullable(clazz.cast(this.buildWorkflowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomatedReasoningPolicyBuildWorkflowResponse, T> g) {
        return obj -> g.apply((StartAutomatedReasoningPolicyBuildWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String policyArn;
        private String buildWorkflowId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomatedReasoningPolicyBuildWorkflowResponse model) {
            super(model);
            this.policyArn(model.policyArn);
            this.buildWorkflowId(model.buildWorkflowId);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return this.buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        @Override
        public StartAutomatedReasoningPolicyBuildWorkflowResponse build() {
            return new StartAutomatedReasoningPolicyBuildWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAutomatedReasoningPolicyBuildWorkflowResponse> {
        public Builder policyArn(String var1);

        public Builder buildWorkflowId(String var1);
    }
}

