/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse;

public class ListAutomatedReasoningPoliciesIterable
implements SdkIterable<ListAutomatedReasoningPoliciesResponse> {
    private final BedrockClient client;
    private final ListAutomatedReasoningPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomatedReasoningPoliciesIterable(BedrockClient client, ListAutomatedReasoningPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomatedReasoningPoliciesResponseFetcher();
    }

    public Iterator<ListAutomatedReasoningPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries() {
        Function<ListAutomatedReasoningPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automatedReasoningPolicySummaries() != null) {
                return response.automatedReasoningPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomatedReasoningPoliciesResponseFetcher
    implements SyncPageFetcher<ListAutomatedReasoningPoliciesResponse> {
        private ListAutomatedReasoningPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomatedReasoningPoliciesResponse nextPage(ListAutomatedReasoningPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPoliciesIterable.this.client.listAutomatedReasoningPolicies(ListAutomatedReasoningPoliciesIterable.this.firstRequest);
            }
            return ListAutomatedReasoningPoliciesIterable.this.client.listAutomatedReasoningPolicies((ListAutomatedReasoningPoliciesRequest)((Object)ListAutomatedReasoningPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

