/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestCase;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestCaseListCopier;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomatedReasoningPolicyTestCasesResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListAutomatedReasoningPolicyTestCasesResponse> {
    private static final SdkField<List<AutomatedReasoningPolicyTestCase>> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testCases").getter(ListAutomatedReasoningPolicyTestCasesResponse.getter(ListAutomatedReasoningPolicyTestCasesResponse::testCases)).setter(ListAutomatedReasoningPolicyTestCasesResponse.setter(Builder::testCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyTestCase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomatedReasoningPolicyTestCasesResponse.getter(ListAutomatedReasoningPolicyTestCasesResponse::nextToken)).setter(ListAutomatedReasoningPolicyTestCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomatedReasoningPolicyTestCasesResponse.memberNameToFieldInitializer();
    private final List<AutomatedReasoningPolicyTestCase> testCases;
    private final String nextToken;

    private ListAutomatedReasoningPolicyTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.testCases = builder.testCases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestCases() {
        return this.testCases != null && !(this.testCases instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyTestCase> testCases() {
        return this.testCases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestCases() ? this.testCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomatedReasoningPolicyTestCasesResponse)) {
            return false;
        }
        ListAutomatedReasoningPolicyTestCasesResponse other = (ListAutomatedReasoningPolicyTestCasesResponse)((Object)obj);
        return this.hasTestCases() == other.hasTestCases() && Objects.equals(this.testCases(), other.testCases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomatedReasoningPolicyTestCasesResponse").add("TestCases", this.hasTestCases() ? this.testCases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testCases", TEST_CASES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomatedReasoningPolicyTestCasesResponse, T> g) {
        return obj -> g.apply((ListAutomatedReasoningPolicyTestCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<AutomatedReasoningPolicyTestCase> testCases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomatedReasoningPolicyTestCasesResponse model) {
            super(model);
            this.testCases(model.testCases);
            this.nextToken(model.nextToken);
        }

        public final List<AutomatedReasoningPolicyTestCase.Builder> getTestCases() {
            List<AutomatedReasoningPolicyTestCase.Builder> result = AutomatedReasoningPolicyTestCaseListCopier.copyToBuilder(this.testCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestCases(Collection<AutomatedReasoningPolicyTestCase.BuilderImpl> testCases) {
            this.testCases = AutomatedReasoningPolicyTestCaseListCopier.copyFromBuilder(testCases);
        }

        @Override
        public final Builder testCases(Collection<AutomatedReasoningPolicyTestCase> testCases) {
            this.testCases = AutomatedReasoningPolicyTestCaseListCopier.copy(testCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(AutomatedReasoningPolicyTestCase ... testCases) {
            this.testCases(Arrays.asList(testCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(Consumer<AutomatedReasoningPolicyTestCase.Builder> ... testCases) {
            this.testCases(Stream.of(testCases).map(c -> (AutomatedReasoningPolicyTestCase)((AutomatedReasoningPolicyTestCase.Builder)AutomatedReasoningPolicyTestCase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomatedReasoningPolicyTestCasesResponse build() {
            return new ListAutomatedReasoningPolicyTestCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomatedReasoningPolicyTestCasesResponse> {
        public Builder testCases(Collection<AutomatedReasoningPolicyTestCase> var1);

        public Builder testCases(AutomatedReasoningPolicyTestCase ... var1);

        public Builder testCases(Consumer<AutomatedReasoningPolicyTestCase.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

