/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.LegalTerm;
import software.amazon.awssdk.services.bedrock.model.PricingTerm;
import software.amazon.awssdk.services.bedrock.model.SupportTerm;
import software.amazon.awssdk.services.bedrock.model.ValidityTerm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TermDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TermDetails> {
    private static final SdkField<PricingTerm> USAGE_BASED_PRICING_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usageBasedPricingTerm").getter(TermDetails.getter(TermDetails::usageBasedPricingTerm)).setter(TermDetails.setter(Builder::usageBasedPricingTerm)).constructor(PricingTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageBasedPricingTerm").build()}).build();
    private static final SdkField<LegalTerm> LEGAL_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("legalTerm").getter(TermDetails.getter(TermDetails::legalTerm)).setter(TermDetails.setter(Builder::legalTerm)).constructor(LegalTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalTerm").build()}).build();
    private static final SdkField<SupportTerm> SUPPORT_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supportTerm").getter(TermDetails.getter(TermDetails::supportTerm)).setter(TermDetails.setter(Builder::supportTerm)).constructor(SupportTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportTerm").build()}).build();
    private static final SdkField<ValidityTerm> VALIDITY_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validityTerm").getter(TermDetails.getter(TermDetails::validityTerm)).setter(TermDetails.setter(Builder::validityTerm)).constructor(ValidityTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validityTerm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_BASED_PRICING_TERM_FIELD, LEGAL_TERM_FIELD, SUPPORT_TERM_FIELD, VALIDITY_TERM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TermDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PricingTerm usageBasedPricingTerm;
    private final LegalTerm legalTerm;
    private final SupportTerm supportTerm;
    private final ValidityTerm validityTerm;

    private TermDetails(BuilderImpl builder) {
        this.usageBasedPricingTerm = builder.usageBasedPricingTerm;
        this.legalTerm = builder.legalTerm;
        this.supportTerm = builder.supportTerm;
        this.validityTerm = builder.validityTerm;
    }

    public final PricingTerm usageBasedPricingTerm() {
        return this.usageBasedPricingTerm;
    }

    public final LegalTerm legalTerm() {
        return this.legalTerm;
    }

    public final SupportTerm supportTerm() {
        return this.supportTerm;
    }

    public final ValidityTerm validityTerm() {
        return this.validityTerm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageBasedPricingTerm());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalTerm());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportTerm());
        hashCode = 31 * hashCode + Objects.hashCode(this.validityTerm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermDetails)) {
            return false;
        }
        TermDetails other = (TermDetails)obj;
        return Objects.equals(this.usageBasedPricingTerm(), other.usageBasedPricingTerm()) && Objects.equals(this.legalTerm(), other.legalTerm()) && Objects.equals(this.supportTerm(), other.supportTerm()) && Objects.equals(this.validityTerm(), other.validityTerm());
    }

    public final String toString() {
        return ToString.builder((String)"TermDetails").add("UsageBasedPricingTerm", (Object)this.usageBasedPricingTerm()).add("LegalTerm", (Object)this.legalTerm()).add("SupportTerm", (Object)this.supportTerm()).add("ValidityTerm", (Object)this.validityTerm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usageBasedPricingTerm": {
                return Optional.ofNullable(clazz.cast(this.usageBasedPricingTerm()));
            }
            case "legalTerm": {
                return Optional.ofNullable(clazz.cast(this.legalTerm()));
            }
            case "supportTerm": {
                return Optional.ofNullable(clazz.cast(this.supportTerm()));
            }
            case "validityTerm": {
                return Optional.ofNullable(clazz.cast(this.validityTerm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usageBasedPricingTerm", USAGE_BASED_PRICING_TERM_FIELD);
        map.put("legalTerm", LEGAL_TERM_FIELD);
        map.put("supportTerm", SUPPORT_TERM_FIELD);
        map.put("validityTerm", VALIDITY_TERM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermDetails, T> g) {
        return obj -> g.apply((TermDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PricingTerm usageBasedPricingTerm;
        private LegalTerm legalTerm;
        private SupportTerm supportTerm;
        private ValidityTerm validityTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(TermDetails model) {
            this.usageBasedPricingTerm(model.usageBasedPricingTerm);
            this.legalTerm(model.legalTerm);
            this.supportTerm(model.supportTerm);
            this.validityTerm(model.validityTerm);
        }

        public final PricingTerm.Builder getUsageBasedPricingTerm() {
            return this.usageBasedPricingTerm != null ? this.usageBasedPricingTerm.toBuilder() : null;
        }

        public final void setUsageBasedPricingTerm(PricingTerm.BuilderImpl usageBasedPricingTerm) {
            this.usageBasedPricingTerm = usageBasedPricingTerm != null ? usageBasedPricingTerm.build() : null;
        }

        @Override
        public final Builder usageBasedPricingTerm(PricingTerm usageBasedPricingTerm) {
            this.usageBasedPricingTerm = usageBasedPricingTerm;
            return this;
        }

        public final LegalTerm.Builder getLegalTerm() {
            return this.legalTerm != null ? this.legalTerm.toBuilder() : null;
        }

        public final void setLegalTerm(LegalTerm.BuilderImpl legalTerm) {
            this.legalTerm = legalTerm != null ? legalTerm.build() : null;
        }

        @Override
        public final Builder legalTerm(LegalTerm legalTerm) {
            this.legalTerm = legalTerm;
            return this;
        }

        public final SupportTerm.Builder getSupportTerm() {
            return this.supportTerm != null ? this.supportTerm.toBuilder() : null;
        }

        public final void setSupportTerm(SupportTerm.BuilderImpl supportTerm) {
            this.supportTerm = supportTerm != null ? supportTerm.build() : null;
        }

        @Override
        public final Builder supportTerm(SupportTerm supportTerm) {
            this.supportTerm = supportTerm;
            return this;
        }

        public final ValidityTerm.Builder getValidityTerm() {
            return this.validityTerm != null ? this.validityTerm.toBuilder() : null;
        }

        public final void setValidityTerm(ValidityTerm.BuilderImpl validityTerm) {
            this.validityTerm = validityTerm != null ? validityTerm.build() : null;
        }

        @Override
        public final Builder validityTerm(ValidityTerm validityTerm) {
            this.validityTerm = validityTerm;
            return this;
        }

        public TermDetails build() {
            return new TermDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TermDetails> {
        public Builder usageBasedPricingTerm(PricingTerm var1);

        default public Builder usageBasedPricingTerm(Consumer<PricingTerm.Builder> usageBasedPricingTerm) {
            return this.usageBasedPricingTerm((PricingTerm)((PricingTerm.Builder)PricingTerm.builder().applyMutation(usageBasedPricingTerm)).build());
        }

        public Builder legalTerm(LegalTerm var1);

        default public Builder legalTerm(Consumer<LegalTerm.Builder> legalTerm) {
            return this.legalTerm((LegalTerm)((LegalTerm.Builder)LegalTerm.builder().applyMutation(legalTerm)).build());
        }

        public Builder supportTerm(SupportTerm var1);

        default public Builder supportTerm(Consumer<SupportTerm.Builder> supportTerm) {
            return this.supportTerm((SupportTerm)((SupportTerm.Builder)SupportTerm.builder().applyMutation(supportTerm)).build());
        }

        public Builder validityTerm(ValidityTerm var1);

        default public Builder validityTerm(Consumer<ValidityTerm.Builder> validityTerm) {
            return this.validityTerm((ValidityTerm)((ValidityTerm.Builder)ValidityTerm.builder().applyMutation(validityTerm)).build());
        }
    }
}

