/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomatedReasoningPolicyAnnotationsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, UpdateAutomatedReasoningPolicyAnnotationsResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAutomatedReasoningPolicyAnnotationsResponse.getter(UpdateAutomatedReasoningPolicyAnnotationsResponse::policyArn)).setter(UpdateAutomatedReasoningPolicyAnnotationsResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildWorkflowId").getter(UpdateAutomatedReasoningPolicyAnnotationsResponse.getter(UpdateAutomatedReasoningPolicyAnnotationsResponse::buildWorkflowId)).setter(UpdateAutomatedReasoningPolicyAnnotationsResponse.setter(Builder::buildWorkflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildWorkflowId").build()}).build();
    private static final SdkField<String> ANNOTATION_SET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("annotationSetHash").getter(UpdateAutomatedReasoningPolicyAnnotationsResponse.getter(UpdateAutomatedReasoningPolicyAnnotationsResponse::annotationSetHash)).setter(UpdateAutomatedReasoningPolicyAnnotationsResponse.setter(Builder::annotationSetHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationSetHash").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateAutomatedReasoningPolicyAnnotationsResponse.getter(UpdateAutomatedReasoningPolicyAnnotationsResponse::updatedAt)).setter(UpdateAutomatedReasoningPolicyAnnotationsResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, BUILD_WORKFLOW_ID_FIELD, ANNOTATION_SET_HASH_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomatedReasoningPolicyAnnotationsResponse.memberNameToFieldInitializer();
    private final String policyArn;
    private final String buildWorkflowId;
    private final String annotationSetHash;
    private final Instant updatedAt;

    private UpdateAutomatedReasoningPolicyAnnotationsResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.annotationSetHash = builder.annotationSetHash;
        this.updatedAt = builder.updatedAt;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String buildWorkflowId() {
        return this.buildWorkflowId;
    }

    public final String annotationSetHash() {
        return this.annotationSetHash;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationSetHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyAnnotationsResponse)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyAnnotationsResponse other = (UpdateAutomatedReasoningPolicyAnnotationsResponse)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.buildWorkflowId(), other.buildWorkflowId()) && Objects.equals(this.annotationSetHash(), other.annotationSetHash()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomatedReasoningPolicyAnnotationsResponse").add("PolicyArn", (Object)this.policyArn()).add("BuildWorkflowId", (Object)this.buildWorkflowId()).add("AnnotationSetHash", (Object)this.annotationSetHash()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "buildWorkflowId": {
                return Optional.ofNullable(clazz.cast(this.buildWorkflowId()));
            }
            case "annotationSetHash": {
                return Optional.ofNullable(clazz.cast(this.annotationSetHash()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("annotationSetHash", ANNOTATION_SET_HASH_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyAnnotationsResponse, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyAnnotationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String policyArn;
        private String buildWorkflowId;
        private String annotationSetHash;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyAnnotationsResponse model) {
            super(model);
            this.policyArn(model.policyArn);
            this.buildWorkflowId(model.buildWorkflowId);
            this.annotationSetHash(model.annotationSetHash);
            this.updatedAt(model.updatedAt);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return this.buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final String getAnnotationSetHash() {
            return this.annotationSetHash;
        }

        public final void setAnnotationSetHash(String annotationSetHash) {
            this.annotationSetHash = annotationSetHash;
        }

        @Override
        public final Builder annotationSetHash(String annotationSetHash) {
            this.annotationSetHash = annotationSetHash;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyAnnotationsResponse build() {
            return new UpdateAutomatedReasoningPolicyAnnotationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyAnnotationsResponse> {
        public Builder policyArn(String var1);

        public Builder buildWorkflowId(String var1);

        public Builder annotationSetHash(String var1);

        public Builder updatedAt(Instant var1);
    }
}

