/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.CommitmentDuration;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisionedModelThroughputRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateProvisionedModelThroughputRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::clientRequestToken)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> MODEL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("modelUnits").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::modelUnits)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::modelUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelUnits").build()}).build();
    private static final SdkField<String> PROVISIONED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisionedModelName").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::provisionedModelName)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::provisionedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelName").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::modelId)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> COMMITMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitmentDuration").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::commitmentDurationAsString)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::commitmentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentDuration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateProvisionedModelThroughputRequest.getter(CreateProvisionedModelThroughputRequest::tags)).setter(CreateProvisionedModelThroughputRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, MODEL_UNITS_FIELD, PROVISIONED_MODEL_NAME_FIELD, MODEL_ID_FIELD, COMMITMENT_DURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProvisionedModelThroughputRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final Integer modelUnits;
    private final String provisionedModelName;
    private final String modelId;
    private final String commitmentDuration;
    private final List<Tag> tags;

    private CreateProvisionedModelThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.modelUnits = builder.modelUnits;
        this.provisionedModelName = builder.provisionedModelName;
        this.modelId = builder.modelId;
        this.commitmentDuration = builder.commitmentDuration;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final Integer modelUnits() {
        return this.modelUnits;
    }

    public final String provisionedModelName() {
        return this.provisionedModelName;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final CommitmentDuration commitmentDuration() {
        return CommitmentDuration.fromValue(this.commitmentDuration);
    }

    public final String commitmentDurationAsString() {
        return this.commitmentDuration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisionedModelThroughputRequest)) {
            return false;
        }
        CreateProvisionedModelThroughputRequest other = (CreateProvisionedModelThroughputRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.modelUnits(), other.modelUnits()) && Objects.equals(this.provisionedModelName(), other.provisionedModelName()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.commitmentDurationAsString(), other.commitmentDurationAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisionedModelThroughputRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("ModelUnits", (Object)this.modelUnits()).add("ProvisionedModelName", (Object)this.provisionedModelName()).add("ModelId", (Object)this.modelId()).add("CommitmentDuration", (Object)this.commitmentDurationAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "modelUnits": {
                return Optional.ofNullable(clazz.cast(this.modelUnits()));
            }
            case "provisionedModelName": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelName()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "commitmentDuration": {
                return Optional.ofNullable(clazz.cast(this.commitmentDurationAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("modelUnits", MODEL_UNITS_FIELD);
        map.put("provisionedModelName", PROVISIONED_MODEL_NAME_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("commitmentDuration", COMMITMENT_DURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisionedModelThroughputRequest, T> g) {
        return obj -> g.apply((CreateProvisionedModelThroughputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private Integer modelUnits;
        private String provisionedModelName;
        private String modelId;
        private String commitmentDuration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisionedModelThroughputRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.modelUnits(model.modelUnits);
            this.provisionedModelName(model.provisionedModelName);
            this.modelId(model.modelId);
            this.commitmentDuration(model.commitmentDuration);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Integer getModelUnits() {
            return this.modelUnits;
        }

        public final void setModelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
        }

        @Override
        public final Builder modelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
            return this;
        }

        public final String getProvisionedModelName() {
            return this.provisionedModelName;
        }

        public final void setProvisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
        }

        @Override
        public final Builder provisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getCommitmentDuration() {
            return this.commitmentDuration;
        }

        public final void setCommitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        @Override
        public final Builder commitmentDuration(CommitmentDuration commitmentDuration) {
            this.commitmentDuration(commitmentDuration == null ? null : commitmentDuration.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisionedModelThroughputRequest build() {
            return new CreateProvisionedModelThroughputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisionedModelThroughputRequest> {
        public Builder clientRequestToken(String var1);

        public Builder modelUnits(Integer var1);

        public Builder provisionedModelName(String var1);

        public Builder modelId(String var1);

        public Builder commitmentDuration(String var1);

        public Builder commitmentDuration(CommitmentDuration var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

