/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.AdditionalModelRequestFieldsCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrock.model.KbInferenceConfig;
import software.amazon.awssdk.services.bedrock.model.PromptTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GenerationConfiguration> {
    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptTemplate").getter(GenerationConfiguration.getter(GenerationConfiguration::promptTemplate)).setter(GenerationConfiguration.setter(Builder::promptTemplate)).constructor(PromptTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(GenerationConfiguration.getter(GenerationConfiguration::guardrailConfiguration)).setter(GenerationConfiguration.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<KbInferenceConfig> KB_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kbInferenceConfig").getter(GenerationConfiguration.getter(GenerationConfiguration::kbInferenceConfig)).setter(GenerationConfiguration.setter(Builder::kbInferenceConfig)).constructor(KbInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kbInferenceConfig").build()}).build();
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalModelRequestFields").getter(GenerationConfiguration.getter(GenerationConfiguration::additionalModelRequestFields)).setter(GenerationConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD, GUARDRAIL_CONFIGURATION_FIELD, KB_INFERENCE_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PromptTemplate promptTemplate;
    private final GuardrailConfiguration guardrailConfiguration;
    private final KbInferenceConfig kbInferenceConfig;
    private final Map<String, Document> additionalModelRequestFields;

    private GenerationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.kbInferenceConfig = builder.kbInferenceConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
    }

    public final PromptTemplate promptTemplate() {
        return this.promptTemplate;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final KbInferenceConfig kbInferenceConfig() {
        return this.kbInferenceConfig;
    }

    public final boolean hasAdditionalModelRequestFields() {
        return this.additionalModelRequestFields != null && !(this.additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kbInferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationConfiguration)) {
            return false;
        }
        GenerationConfiguration other = (GenerationConfiguration)obj;
        return Objects.equals(this.promptTemplate(), other.promptTemplate()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.kbInferenceConfig(), other.kbInferenceConfig()) && this.hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields() && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields());
    }

    public final String toString() {
        return ToString.builder((String)"GenerationConfiguration").add("PromptTemplate", (Object)this.promptTemplate()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("KbInferenceConfig", (Object)this.kbInferenceConfig()).add("AdditionalModelRequestFields", this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptTemplate": {
                return Optional.ofNullable(clazz.cast(this.promptTemplate()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "kbInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.kbInferenceConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("kbInferenceConfig", KB_INFERENCE_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerationConfiguration, T> g) {
        return obj -> g.apply((GenerationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PromptTemplate promptTemplate;
        private GuardrailConfiguration guardrailConfiguration;
        private KbInferenceConfig kbInferenceConfig;
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationConfiguration model) {
            this.promptTemplate(model.promptTemplate);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.kbInferenceConfig(model.kbInferenceConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return this.promptTemplate != null ? this.promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final KbInferenceConfig.Builder getKbInferenceConfig() {
            return this.kbInferenceConfig != null ? this.kbInferenceConfig.toBuilder() : null;
        }

        public final void setKbInferenceConfig(KbInferenceConfig.BuilderImpl kbInferenceConfig) {
            this.kbInferenceConfig = kbInferenceConfig != null ? kbInferenceConfig.build() : null;
        }

        @Override
        public final Builder kbInferenceConfig(KbInferenceConfig kbInferenceConfig) {
            this.kbInferenceConfig = kbInferenceConfig;
            return this;
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (this.additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public GenerationConfiguration build() {
            return new GenerationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GenerationConfiguration> {
        public Builder promptTemplate(PromptTemplate var1);

        default public Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return this.promptTemplate((PromptTemplate)((PromptTemplate.Builder)PromptTemplate.builder().applyMutation(promptTemplate)).build());
        }

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder kbInferenceConfig(KbInferenceConfig var1);

        default public Builder kbInferenceConfig(Consumer<KbInferenceConfig.Builder> kbInferenceConfig) {
            return this.kbInferenceConfig((KbInferenceConfig)((KbInferenceConfig.Builder)KbInferenceConfig.builder().applyMutation(kbInferenceConfig)).build());
        }

        public Builder additionalModelRequestFields(Map<String, Document> var1);
    }
}

