/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.TermDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Offer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Offer> {
    private static final SdkField<String> OFFER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offerId").getter(Offer.getter(Offer::offerId)).setter(Offer.setter(Builder::offerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerId").build()}).build();
    private static final SdkField<String> OFFER_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offerToken").getter(Offer.getter(Offer::offerToken)).setter(Offer.setter(Builder::offerToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerToken").build()}).build();
    private static final SdkField<TermDetails> TERM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("termDetails").getter(Offer.getter(Offer::termDetails)).setter(Offer.setter(Builder::termDetails)).constructor(TermDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFER_ID_FIELD, OFFER_TOKEN_FIELD, TERM_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Offer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String offerId;
    private final String offerToken;
    private final TermDetails termDetails;

    private Offer(BuilderImpl builder) {
        this.offerId = builder.offerId;
        this.offerToken = builder.offerToken;
        this.termDetails = builder.termDetails;
    }

    public final String offerId() {
        return this.offerId;
    }

    public final String offerToken() {
        return this.offerToken;
    }

    public final TermDetails termDetails() {
        return this.termDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.termDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offer)) {
            return false;
        }
        Offer other = (Offer)obj;
        return Objects.equals(this.offerId(), other.offerId()) && Objects.equals(this.offerToken(), other.offerToken()) && Objects.equals(this.termDetails(), other.termDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Offer").add("OfferId", (Object)this.offerId()).add("OfferToken", (Object)this.offerToken()).add("TermDetails", (Object)this.termDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offerId": {
                return Optional.ofNullable(clazz.cast(this.offerId()));
            }
            case "offerToken": {
                return Optional.ofNullable(clazz.cast(this.offerToken()));
            }
            case "termDetails": {
                return Optional.ofNullable(clazz.cast(this.termDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("offerId", OFFER_ID_FIELD);
        map.put("offerToken", OFFER_TOKEN_FIELD);
        map.put("termDetails", TERM_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Offer, T> g) {
        return obj -> g.apply((Offer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String offerId;
        private String offerToken;
        private TermDetails termDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Offer model) {
            this.offerId(model.offerId);
            this.offerToken(model.offerToken);
            this.termDetails(model.termDetails);
        }

        public final String getOfferId() {
            return this.offerId;
        }

        public final void setOfferId(String offerId) {
            this.offerId = offerId;
        }

        @Override
        public final Builder offerId(String offerId) {
            this.offerId = offerId;
            return this;
        }

        public final String getOfferToken() {
            return this.offerToken;
        }

        public final void setOfferToken(String offerToken) {
            this.offerToken = offerToken;
        }

        @Override
        public final Builder offerToken(String offerToken) {
            this.offerToken = offerToken;
            return this;
        }

        public final TermDetails.Builder getTermDetails() {
            return this.termDetails != null ? this.termDetails.toBuilder() : null;
        }

        public final void setTermDetails(TermDetails.BuilderImpl termDetails) {
            this.termDetails = termDetails != null ? termDetails.build() : null;
        }

        @Override
        public final Builder termDetails(TermDetails termDetails) {
            this.termDetails = termDetails;
            return this;
        }

        public Offer build() {
            return new Offer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Offer> {
        public Builder offerId(String var1);

        public Builder offerToken(String var1);

        public Builder termDetails(TermDetails var1);

        default public Builder termDetails(Consumer<TermDetails.Builder> termDetails) {
            return this.termDetails((TermDetails)((TermDetails.Builder)TermDetails.builder().applyMutation(termDetails)).build());
        }
    }
}

