/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPromptRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, GetPromptRequest> {
    private static final SdkField<String> PROMPT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptIdentifier").getter(GetPromptRequest.getter(GetPromptRequest::promptIdentifier)).setter(GetPromptRequest.setter(Builder::promptIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("promptIdentifier").build()}).build();
    private static final SdkField<String> PROMPT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptVersion").getter(GetPromptRequest.getter(GetPromptRequest::promptVersion)).setter(GetPromptRequest.setter(Builder::promptVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("promptVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_IDENTIFIER_FIELD, PROMPT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPromptRequest.memberNameToFieldInitializer();
    private final String promptIdentifier;
    private final String promptVersion;

    private GetPromptRequest(BuilderImpl builder) {
        super(builder);
        this.promptIdentifier = builder.promptIdentifier;
        this.promptVersion = builder.promptVersion;
    }

    public final String promptIdentifier() {
        return this.promptIdentifier;
    }

    public final String promptVersion() {
        return this.promptVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.promptIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPromptRequest)) {
            return false;
        }
        GetPromptRequest other = (GetPromptRequest)((Object)obj);
        return Objects.equals(this.promptIdentifier(), other.promptIdentifier()) && Objects.equals(this.promptVersion(), other.promptVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetPromptRequest").add("PromptIdentifier", (Object)this.promptIdentifier()).add("PromptVersion", (Object)this.promptVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptIdentifier": {
                return Optional.ofNullable(clazz.cast(this.promptIdentifier()));
            }
            case "promptVersion": {
                return Optional.ofNullable(clazz.cast(this.promptVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("promptIdentifier", PROMPT_IDENTIFIER_FIELD);
        map.put("promptVersion", PROMPT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPromptRequest, T> g) {
        return obj -> g.apply((GetPromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String promptIdentifier;
        private String promptVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPromptRequest model) {
            super(model);
            this.promptIdentifier(model.promptIdentifier);
            this.promptVersion(model.promptVersion);
        }

        public final String getPromptIdentifier() {
            return this.promptIdentifier;
        }

        public final void setPromptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
        }

        @Override
        public final Builder promptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
            return this;
        }

        public final String getPromptVersion() {
            return this.promptVersion;
        }

        public final void setPromptVersion(String promptVersion) {
            this.promptVersion = promptVersion;
        }

        @Override
        public final Builder promptVersion(String promptVersion) {
            this.promptVersion = promptVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPromptRequest build() {
            return new GetPromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPromptRequest> {
        public Builder promptIdentifier(String var1);

        public Builder promptVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

