/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FailureReasonsCopier;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobStatistics;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionJob> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(IngestionJob.getter(IngestionJob::knowledgeBaseId)).setter(IngestionJob.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(IngestionJob.getter(IngestionJob::dataSourceId)).setter(IngestionJob.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionJobId").getter(IngestionJob.getter(IngestionJob::ingestionJobId)).setter(IngestionJob.setter(Builder::ingestionJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJobId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IngestionJob.getter(IngestionJob::description)).setter(IngestionJob.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(IngestionJob.getter(IngestionJob::statusAsString)).setter(IngestionJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<IngestionJobStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(IngestionJob.getter(IngestionJob::statistics)).setter(IngestionJob.setter(Builder::statistics)).constructor(IngestionJobStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(IngestionJob.getter(IngestionJob::failureReasons)).setter(IngestionJob.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(IngestionJob.getter(IngestionJob::startedAt)).setter(IngestionJob.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(IngestionJob.getter(IngestionJob::updatedAt)).setter(IngestionJob.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, DATA_SOURCE_ID_FIELD, INGESTION_JOB_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATISTICS_FIELD, FAILURE_REASONS_FIELD, STARTED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngestionJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String dataSourceId;
    private final String ingestionJobId;
    private final String description;
    private final String status;
    private final IngestionJobStatistics statistics;
    private final List<String> failureReasons;
    private final Instant startedAt;
    private final Instant updatedAt;

    private IngestionJob(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.ingestionJobId = builder.ingestionJobId;
        this.description = builder.description;
        this.status = builder.status;
        this.statistics = builder.statistics;
        this.failureReasons = builder.failureReasons;
        this.startedAt = builder.startedAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String ingestionJobId() {
        return this.ingestionJobId;
    }

    public final String description() {
        return this.description;
    }

    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final IngestionJobStatistics statistics() {
        return this.statistics;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJob)) {
            return false;
        }
        IngestionJob other = (IngestionJob)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.ingestionJobId(), other.ingestionJobId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statistics(), other.statistics()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionJob").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("DataSourceId", (Object)this.dataSourceId()).add("IngestionJobId", (Object)this.ingestionJobId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Statistics", (Object)this.statistics()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("StartedAt", (Object)this.startedAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "ingestionJobId": {
                return Optional.ofNullable(clazz.cast(this.ingestionJobId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("ingestionJobId", INGESTION_JOB_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionJob, T> g) {
        return obj -> g.apply((IngestionJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String dataSourceId;
        private String ingestionJobId;
        private String description;
        private String status;
        private IngestionJobStatistics statistics;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private Instant startedAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJob model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.dataSourceId(model.dataSourceId);
            this.ingestionJobId(model.ingestionJobId);
            this.description(model.description);
            this.status(model.status);
            this.statistics(model.statistics);
            this.failureReasons(model.failureReasons);
            this.startedAt(model.startedAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getIngestionJobId() {
            return this.ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final IngestionJobStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(IngestionJobStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(IngestionJobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public IngestionJob build() {
            return new IngestionJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionJob> {
        public Builder knowledgeBaseId(String var1);

        public Builder dataSourceId(String var1);

        public Builder ingestionJobId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(IngestionJobStatus var1);

        public Builder statistics(IngestionJobStatistics var1);

        default public Builder statistics(Consumer<IngestionJobStatistics.Builder> statistics) {
            return this.statistics((IngestionJobStatistics)((IngestionJobStatistics.Builder)IngestionJobStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder startedAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

