/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse;

public class ListAgentActionGroupsPublisher
implements SdkPublisher<ListAgentActionGroupsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentActionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentActionGroupsPublisher(BedrockAgentAsyncClient client, ListAgentActionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentActionGroupsPublisher(BedrockAgentAsyncClient client, ListAgentActionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentActionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentActionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionGroupSummary> actionGroupSummaries() {
        Function<ListAgentActionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionGroupSummaries() != null) {
                return response.actionGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentActionGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentActionGroupsResponseFetcher
    implements AsyncPageFetcher<ListAgentActionGroupsResponse> {
        private ListAgentActionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentActionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentActionGroupsResponse> nextPage(ListAgentActionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentActionGroupsPublisher.this.client.listAgentActionGroups(ListAgentActionGroupsPublisher.this.firstRequest);
            }
            return ListAgentActionGroupsPublisher.this.client.listAgentActionGroups((ListAgentActionGroupsRequest)((Object)ListAgentActionGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

