/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the path to the S3 location where you want to store job artifacts and the encryption key used to store
 * them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobOutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<JobOutputDataConfig.Builder, JobOutputDataConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(JobOutputDataConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Path")
            .getter(getter(JobOutputDataConfig::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            S3_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String s3Path;

    private JobOutputDataConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3Path = builder.s3Path;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training artifacts at
     * rest using Amazon S3 server-side encryption.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training
     *         artifacts at rest using Amazon S3 server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example,
     * <code>s3://bucket-name/key-name-prefix</code>.
     * </p>
     * 
     * @return Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example,
     *         <code>s3://bucket-name/key-name-prefix</code>.
     */
    public final String s3Path() {
        return s3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOutputDataConfig)) {
            return false;
        }
        JobOutputDataConfig other = (JobOutputDataConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(s3Path(), other.s3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobOutputDataConfig").add("KmsKeyId", kmsKeyId()).add("S3Path", s3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "s3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobOutputDataConfig, T> g) {
        return obj -> g.apply((JobOutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobOutputDataConfig> {
        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training artifacts at
         * rest using Amazon S3 server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training
         *        artifacts at rest using Amazon S3 server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example,
         * <code>s3://bucket-name/key-name-prefix</code>.
         * </p>
         * 
         * @param s3Path
         *        Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example,
         *        <code>s3://bucket-name/key-name-prefix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String s3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOutputDataConfig model) {
            kmsKeyId(model.kmsKeyId);
            s3Path(model.s3Path);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        @Override
        public JobOutputDataConfig build() {
            return new JobOutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
