/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * Internal implementation of {@link CloudHsmAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudHsmAsyncClientBuilder extends
        DefaultCloudHsmBaseClientBuilder<CloudHsmAsyncClientBuilder, CloudHsmAsyncClient> implements CloudHsmAsyncClientBuilder {
    @Override
    protected final CloudHsmAsyncClient buildClient() {
        return new DefaultCloudHsmAsyncClient(super.asyncClientConfiguration());
    }
}
