/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.BillingMode;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventDataStoreRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, UpdateEventDataStoreRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::eventDataStore)).setter(UpdateEventDataStoreRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::name)).setter(UpdateEventDataStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedEventSelectors").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::advancedEventSelectors)).setter(UpdateEventDataStoreRequest.setter(Builder::advancedEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedEventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiRegionEnabled").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::multiRegionEnabled)).setter(UpdateEventDataStoreRequest.setter(Builder::multiRegionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build()}).build();
    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OrganizationEnabled").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::organizationEnabled)).setter(UpdateEventDataStoreRequest.setter(Builder::organizationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriod").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::retentionPeriod)).setter(UpdateEventDataStoreRequest.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::terminationProtectionEnabled)).setter(UpdateEventDataStoreRequest.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::kmsKeyId)).setter(UpdateEventDataStoreRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingMode").getter(UpdateEventDataStoreRequest.getter(UpdateEventDataStoreRequest::billingModeAsString)).setter(UpdateEventDataStoreRequest.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD, NAME_FIELD, ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD, RETENTION_PERIOD_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, KMS_KEY_ID_FIELD, BILLING_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEventDataStoreRequest.memberNameToFieldInitializer();
    private final String eventDataStore;
    private final String name;
    private final List<AdvancedEventSelector> advancedEventSelectors;
    private final Boolean multiRegionEnabled;
    private final Boolean organizationEnabled;
    private final Integer retentionPeriod;
    private final Boolean terminationProtectionEnabled;
    private final String kmsKeyId;
    private final String billingMode;

    private UpdateEventDataStoreRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.name = builder.name;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.billingMode = builder.billingMode;
    }

    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAdvancedEventSelectors() {
        return this.advancedEventSelectors != null && !(this.advancedEventSelectors instanceof SdkAutoConstructList);
    }

    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return this.advancedEventSelectors;
    }

    public final Boolean multiRegionEnabled() {
        return this.multiRegionEnabled;
    }

    public final Boolean organizationEnabled() {
        return this.organizationEnabled;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public final String billingModeAsString() {
        return this.billingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventDataStoreRequest)) {
            return false;
        }
        UpdateEventDataStoreRequest other = (UpdateEventDataStoreRequest)((Object)obj);
        return Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.name(), other.name()) && this.hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors() && Objects.equals(this.advancedEventSelectors(), other.advancedEventSelectors()) && Objects.equals(this.multiRegionEnabled(), other.multiRegionEnabled()) && Objects.equals(this.organizationEnabled(), other.organizationEnabled()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.billingModeAsString(), other.billingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventDataStoreRequest").add("EventDataStore", (Object)this.eventDataStore()).add("Name", (Object)this.name()).add("AdvancedEventSelectors", this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null).add("MultiRegionEnabled", (Object)this.multiRegionEnabled()).add("OrganizationEnabled", (Object)this.organizationEnabled()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("BillingMode", (Object)this.billingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AdvancedEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.advancedEventSelectors()));
            }
            case "MultiRegionEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiRegionEnabled()));
            }
            case "OrganizationEnabled": {
                return Optional.ofNullable(clazz.cast(this.organizationEnabled()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AdvancedEventSelectors", ADVANCED_EVENT_SELECTORS_FIELD);
        map.put("MultiRegionEnabled", MULTI_REGION_ENABLED_FIELD);
        map.put("OrganizationEnabled", ORGANIZATION_ENABLED_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("BillingMode", BILLING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventDataStoreRequest, T> g) {
        return obj -> g.apply((UpdateEventDataStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventDataStore;
        private String name;
        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiRegionEnabled;
        private Boolean organizationEnabled;
        private Integer retentionPeriod;
        private Boolean terminationProtectionEnabled;
        private String kmsKeyId;
        private String billingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventDataStoreRequest model) {
            super(model);
            this.eventDataStore(model.eventDataStore);
            this.name(model.name);
            this.advancedEventSelectors(model.advancedEventSelectors);
            this.multiRegionEnabled(model.multiRegionEnabled);
            this.organizationEnabled(model.organizationEnabled);
            this.retentionPeriod(model.retentionPeriod);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.billingMode(model.billingMode);
        }

        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
            this.advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... advancedEventSelectors) {
            this.advancedEventSelectors(Stream.of(advancedEventSelectors).map(c -> (AdvancedEventSelector)((AdvancedEventSelector.Builder)AdvancedEventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        public final Boolean getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventDataStoreRequest build() {
            return new UpdateEventDataStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventDataStoreRequest> {
        public Builder eventDataStore(String var1);

        public Builder name(String var1);

        public Builder advancedEventSelectors(Collection<AdvancedEventSelector> var1);

        public Builder advancedEventSelectors(AdvancedEventSelector ... var1);

        public Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... var1);

        public Builder multiRegionEnabled(Boolean var1);

        public Builder organizationEnabled(Boolean var1);

        public Builder retentionPeriod(Integer var1);

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

