/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryStatus {
    SUCCESS("SUCCESS"),
    FAILED("FAILED"),
    FAILED_SIGNING_FILE("FAILED_SIGNING_FILE"),
    PENDING("PENDING"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    ACCESS_DENIED("ACCESS_DENIED"),
    ACCESS_DENIED_SIGNING_FILE("ACCESS_DENIED_SIGNING_FILE"),
    CANCELLED("CANCELLED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryStatus> VALUE_MAP;
    private final String value;

    private DeliveryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryStatus> knownValues() {
        EnumSet<DeliveryStatus> knownValues = EnumSet.allOf(DeliveryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryStatus.class, DeliveryStatus::toString);
    }
}

