/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFederationRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, EnableFederationRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(EnableFederationRequest.getter(EnableFederationRequest::eventDataStore)).setter(EnableFederationRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> FEDERATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationRoleArn").getter(EnableFederationRequest.getter(EnableFederationRequest::federationRoleArn)).setter(EnableFederationRequest.setter(Builder::federationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD, FEDERATION_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableFederationRequest.memberNameToFieldInitializer();
    private final String eventDataStore;
    private final String federationRoleArn;

    private EnableFederationRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.federationRoleArn = builder.federationRoleArn;
    }

    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final String federationRoleArn() {
        return this.federationRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFederationRequest)) {
            return false;
        }
        EnableFederationRequest other = (EnableFederationRequest)((Object)obj);
        return Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.federationRoleArn(), other.federationRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFederationRequest").add("EventDataStore", (Object)this.eventDataStore()).add("FederationRoleArn", (Object)this.federationRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "FederationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.federationRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("FederationRoleArn", FEDERATION_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFederationRequest, T> g) {
        return obj -> g.apply((EnableFederationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventDataStore;
        private String federationRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFederationRequest model) {
            super(model);
            this.eventDataStore(model.eventDataStore);
            this.federationRoleArn(model.federationRoleArn);
        }

        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getFederationRoleArn() {
            return this.federationRoleArn;
        }

        public final void setFederationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
        }

        @Override
        public final Builder federationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFederationRequest build() {
            return new EnableFederationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFederationRequest> {
        public Builder eventDataStore(String var1);

        public Builder federationRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

