/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, GetQueryResultsRequest> {
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::eventDataStore)).setter(GetQueryResultsRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::queryId)).setter(GetQueryResultsRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::nextToken)).setter(GetQueryResultsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_QUERY_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxQueryResults").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::maxQueryResults)).setter(GetQueryResultsRequest.setter(Builder::maxQueryResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxQueryResults").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreOwnerAccountId").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::eventDataStoreOwnerAccountId)).setter(GetQueryResultsRequest.setter(Builder::eventDataStoreOwnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_FIELD, QUERY_ID_FIELD, NEXT_TOKEN_FIELD, MAX_QUERY_RESULTS_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryResultsRequest.memberNameToFieldInitializer();
    private final String eventDataStore;
    private final String queryId;
    private final String nextToken;
    private final Integer maxQueryResults;
    private final String eventDataStoreOwnerAccountId;

    private GetQueryResultsRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStore = builder.eventDataStore;
        this.queryId = builder.queryId;
        this.nextToken = builder.nextToken;
        this.maxQueryResults = builder.maxQueryResults;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    @Deprecated
    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxQueryResults() {
        return this.maxQueryResults;
    }

    public final String eventDataStoreOwnerAccountId() {
        return this.eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxQueryResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreOwnerAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsRequest)) {
            return false;
        }
        GetQueryResultsRequest other = (GetQueryResultsRequest)((Object)obj);
        return Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxQueryResults(), other.maxQueryResults()) && Objects.equals(this.eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsRequest").add("EventDataStore", (Object)this.eventDataStore()).add("QueryId", (Object)this.queryId()).add("NextToken", (Object)this.nextToken()).add("MaxQueryResults", (Object)this.maxQueryResults()).add("EventDataStoreOwnerAccountId", (Object)this.eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxQueryResults": {
                return Optional.ofNullable(clazz.cast(this.maxQueryResults()));
            }
            case "EventDataStoreOwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreOwnerAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxQueryResults", MAX_QUERY_RESULTS_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsRequest, T> g) {
        return obj -> g.apply((GetQueryResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventDataStore;
        private String queryId;
        private String nextToken;
        private Integer maxQueryResults;
        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsRequest model) {
            super(model);
            this.eventDataStore(model.eventDataStore);
            this.queryId(model.queryId);
            this.nextToken(model.nextToken);
            this.maxQueryResults(model.maxQueryResults);
            this.eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        @Deprecated
        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        @Deprecated
        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        @Deprecated
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxQueryResults() {
            return this.maxQueryResults;
        }

        public final void setMaxQueryResults(Integer maxQueryResults) {
            this.maxQueryResults = maxQueryResults;
        }

        @Override
        public final Builder maxQueryResults(Integer maxQueryResults) {
            this.maxQueryResults = maxQueryResults;
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return this.eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueryResultsRequest build() {
            return new GetQueryResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsRequest> {
        @Deprecated
        public Builder eventDataStore(String var1);

        public Builder queryId(String var1);

        public Builder nextToken(String var1);

        public Builder maxQueryResults(Integer var1);

        public Builder eventDataStoreOwnerAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

