/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePolicyResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetResourcePolicyResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::resourceArn)).setter(GetResourcePolicyResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePolicy").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::resourcePolicy)).setter(GetResourcePolicyResponse.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()}).build();
    private static final SdkField<String> DELEGATED_ADMIN_RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DelegatedAdminResourcePolicy").getter(GetResourcePolicyResponse.getter(GetResourcePolicyResponse::delegatedAdminResourcePolicy)).setter(GetResourcePolicyResponse.setter(Builder::delegatedAdminResourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegatedAdminResourcePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_POLICY_FIELD, DELEGATED_ADMIN_RESOURCE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcePolicyResponse.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String resourcePolicy;
    private final String delegatedAdminResourcePolicy;

    private GetResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.resourcePolicy = builder.resourcePolicy;
        this.delegatedAdminResourcePolicy = builder.delegatedAdminResourcePolicy;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourcePolicy() {
        return this.resourcePolicy;
    }

    public final String delegatedAdminResourcePolicy() {
        return this.delegatedAdminResourcePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegatedAdminResourcePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePolicyResponse)) {
            return false;
        }
        GetResourcePolicyResponse other = (GetResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy()) && Objects.equals(this.delegatedAdminResourcePolicy(), other.delegatedAdminResourcePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePolicyResponse").add("ResourceArn", (Object)this.resourceArn()).add("ResourcePolicy", (Object)this.resourcePolicy()).add("DelegatedAdminResourcePolicy", (Object)this.delegatedAdminResourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
            case "DelegatedAdminResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.delegatedAdminResourcePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("DelegatedAdminResourcePolicy", DELEGATED_ADMIN_RESOURCE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourcePolicy;
        private String delegatedAdminResourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePolicyResponse model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.resourcePolicy(model.resourcePolicy);
            this.delegatedAdminResourcePolicy(model.delegatedAdminResourcePolicy);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final String getDelegatedAdminResourcePolicy() {
            return this.delegatedAdminResourcePolicy;
        }

        public final void setDelegatedAdminResourcePolicy(String delegatedAdminResourcePolicy) {
            this.delegatedAdminResourcePolicy = delegatedAdminResourcePolicy;
        }

        @Override
        public final Builder delegatedAdminResourcePolicy(String delegatedAdminResourcePolicy) {
            this.delegatedAdminResourcePolicy = delegatedAdminResourcePolicy;
            return this;
        }

        @Override
        public GetResourcePolicyResponse build() {
            return new GetResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePolicyResponse> {
        public Builder resourceArn(String var1);

        public Builder resourcePolicy(String var1);

        public Builder delegatedAdminResourcePolicy(String var1);
    }
}

