/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.DataResource;
import software.amazon.awssdk.services.cloudtrail.model.DataResourcesCopier;
import software.amazon.awssdk.services.cloudtrail.model.ExcludeManagementEventSourcesCopier;
import software.amazon.awssdk.services.cloudtrail.model.ReadWriteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSelector> {
    private static final SdkField<String> READ_WRITE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadWriteType").getter(EventSelector.getter(EventSelector::readWriteTypeAsString)).setter(EventSelector.setter(Builder::readWriteType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadWriteType").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MANAGEMENT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeManagementEvents").getter(EventSelector.getter(EventSelector::includeManagementEvents)).setter(EventSelector.setter(Builder::includeManagementEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeManagementEvents").build()}).build();
    private static final SdkField<List<DataResource>> DATA_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataResources").getter(EventSelector.getter(EventSelector::dataResources)).setter(EventSelector.setter(Builder::dataResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_MANAGEMENT_EVENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeManagementEventSources").getter(EventSelector.getter(EventSelector::excludeManagementEventSources)).setter(EventSelector.setter(Builder::excludeManagementEventSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeManagementEventSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_WRITE_TYPE_FIELD, INCLUDE_MANAGEMENT_EVENTS_FIELD, DATA_RESOURCES_FIELD, EXCLUDE_MANAGEMENT_EVENT_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String readWriteType;
    private final Boolean includeManagementEvents;
    private final List<DataResource> dataResources;
    private final List<String> excludeManagementEventSources;

    private EventSelector(BuilderImpl builder) {
        this.readWriteType = builder.readWriteType;
        this.includeManagementEvents = builder.includeManagementEvents;
        this.dataResources = builder.dataResources;
        this.excludeManagementEventSources = builder.excludeManagementEventSources;
    }

    public final ReadWriteType readWriteType() {
        return ReadWriteType.fromValue(this.readWriteType);
    }

    public final String readWriteTypeAsString() {
        return this.readWriteType;
    }

    public final Boolean includeManagementEvents() {
        return this.includeManagementEvents;
    }

    public final boolean hasDataResources() {
        return this.dataResources != null && !(this.dataResources instanceof SdkAutoConstructList);
    }

    public final List<DataResource> dataResources() {
        return this.dataResources;
    }

    public final boolean hasExcludeManagementEventSources() {
        return this.excludeManagementEventSources != null && !(this.excludeManagementEventSources instanceof SdkAutoConstructList);
    }

    public final List<String> excludeManagementEventSources() {
        return this.excludeManagementEventSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readWriteTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeManagementEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataResources() ? this.dataResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeManagementEventSources() ? this.excludeManagementEventSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSelector)) {
            return false;
        }
        EventSelector other = (EventSelector)obj;
        return Objects.equals(this.readWriteTypeAsString(), other.readWriteTypeAsString()) && Objects.equals(this.includeManagementEvents(), other.includeManagementEvents()) && this.hasDataResources() == other.hasDataResources() && Objects.equals(this.dataResources(), other.dataResources()) && this.hasExcludeManagementEventSources() == other.hasExcludeManagementEventSources() && Objects.equals(this.excludeManagementEventSources(), other.excludeManagementEventSources());
    }

    public final String toString() {
        return ToString.builder((String)"EventSelector").add("ReadWriteType", (Object)this.readWriteTypeAsString()).add("IncludeManagementEvents", (Object)this.includeManagementEvents()).add("DataResources", this.hasDataResources() ? this.dataResources() : null).add("ExcludeManagementEventSources", this.hasExcludeManagementEventSources() ? this.excludeManagementEventSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadWriteType": {
                return Optional.ofNullable(clazz.cast(this.readWriteTypeAsString()));
            }
            case "IncludeManagementEvents": {
                return Optional.ofNullable(clazz.cast(this.includeManagementEvents()));
            }
            case "DataResources": {
                return Optional.ofNullable(clazz.cast(this.dataResources()));
            }
            case "ExcludeManagementEventSources": {
                return Optional.ofNullable(clazz.cast(this.excludeManagementEventSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReadWriteType", READ_WRITE_TYPE_FIELD);
        map.put("IncludeManagementEvents", INCLUDE_MANAGEMENT_EVENTS_FIELD);
        map.put("DataResources", DATA_RESOURCES_FIELD);
        map.put("ExcludeManagementEventSources", EXCLUDE_MANAGEMENT_EVENT_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventSelector, T> g) {
        return obj -> g.apply((EventSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String readWriteType;
        private Boolean includeManagementEvents;
        private List<DataResource> dataResources = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeManagementEventSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSelector model) {
            this.readWriteType(model.readWriteType);
            this.includeManagementEvents(model.includeManagementEvents);
            this.dataResources(model.dataResources);
            this.excludeManagementEventSources(model.excludeManagementEventSources);
        }

        public final String getReadWriteType() {
            return this.readWriteType;
        }

        public final void setReadWriteType(String readWriteType) {
            this.readWriteType = readWriteType;
        }

        @Override
        public final Builder readWriteType(String readWriteType) {
            this.readWriteType = readWriteType;
            return this;
        }

        @Override
        public final Builder readWriteType(ReadWriteType readWriteType) {
            this.readWriteType(readWriteType == null ? null : readWriteType.toString());
            return this;
        }

        public final Boolean getIncludeManagementEvents() {
            return this.includeManagementEvents;
        }

        public final void setIncludeManagementEvents(Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
        }

        @Override
        public final Builder includeManagementEvents(Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
            return this;
        }

        public final List<DataResource.Builder> getDataResources() {
            List<DataResource.Builder> result = DataResourcesCopier.copyToBuilder(this.dataResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataResources(Collection<DataResource.BuilderImpl> dataResources) {
            this.dataResources = DataResourcesCopier.copyFromBuilder(dataResources);
        }

        @Override
        public final Builder dataResources(Collection<DataResource> dataResources) {
            this.dataResources = DataResourcesCopier.copy(dataResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResources(DataResource ... dataResources) {
            this.dataResources(Arrays.asList(dataResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataResources(Consumer<DataResource.Builder> ... dataResources) {
            this.dataResources(Stream.of(dataResources).map(c -> (DataResource)((DataResource.Builder)DataResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExcludeManagementEventSources() {
            if (this.excludeManagementEventSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeManagementEventSources;
        }

        public final void setExcludeManagementEventSources(Collection<String> excludeManagementEventSources) {
            this.excludeManagementEventSources = ExcludeManagementEventSourcesCopier.copy(excludeManagementEventSources);
        }

        @Override
        public final Builder excludeManagementEventSources(Collection<String> excludeManagementEventSources) {
            this.excludeManagementEventSources = ExcludeManagementEventSourcesCopier.copy(excludeManagementEventSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeManagementEventSources(String ... excludeManagementEventSources) {
            this.excludeManagementEventSources(Arrays.asList(excludeManagementEventSources));
            return this;
        }

        public EventSelector build() {
            return new EventSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSelector> {
        public Builder readWriteType(String var1);

        public Builder readWriteType(ReadWriteType var1);

        public Builder includeManagementEvents(Boolean var1);

        public Builder dataResources(Collection<DataResource> var1);

        public Builder dataResources(DataResource ... var1);

        public Builder dataResources(Consumer<DataResource.Builder> ... var1);

        public Builder excludeManagementEventSources(Collection<String> var1);

        public Builder excludeManagementEventSources(String ... var1);
    }
}

