/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DashboardStatus;
import software.amazon.awssdk.services.cloudtrail.model.DashboardType;
import software.amazon.awssdk.services.cloudtrail.model.RefreshSchedule;
import software.amazon.awssdk.services.cloudtrail.model.Widget;
import software.amazon.awssdk.services.cloudtrail.model.WidgetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashboardResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(GetDashboardResponse.getter(GetDashboardResponse::dashboardArn)).setter(GetDashboardResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetDashboardResponse.getter(GetDashboardResponse::typeAsString)).setter(GetDashboardResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDashboardResponse.getter(GetDashboardResponse::statusAsString)).setter(GetDashboardResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Widget>> WIDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Widgets").getter(GetDashboardResponse.getter(GetDashboardResponse::widgets)).setter(GetDashboardResponse.setter(Builder::widgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Widget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshSchedule").getter(GetDashboardResponse.getter(GetDashboardResponse::refreshSchedule)).setter(GetDashboardResponse.setter(Builder::refreshSchedule)).constructor(RefreshSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetDashboardResponse.getter(GetDashboardResponse::createdTimestamp)).setter(GetDashboardResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(GetDashboardResponse.getter(GetDashboardResponse::updatedTimestamp)).setter(GetDashboardResponse.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()}).build();
    private static final SdkField<String> LAST_REFRESH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRefreshId").getter(GetDashboardResponse.getter(GetDashboardResponse::lastRefreshId)).setter(GetDashboardResponse.setter(Builder::lastRefreshId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshId").build()}).build();
    private static final SdkField<String> LAST_REFRESH_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRefreshFailureReason").getter(GetDashboardResponse.getter(GetDashboardResponse::lastRefreshFailureReason)).setter(GetDashboardResponse.setter(Builder::lastRefreshFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshFailureReason").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(GetDashboardResponse.getter(GetDashboardResponse::terminationProtectionEnabled)).setter(GetDashboardResponse.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, TYPE_FIELD, STATUS_FIELD, WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, LAST_REFRESH_ID_FIELD, LAST_REFRESH_FAILURE_REASON_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDashboardResponse.memberNameToFieldInitializer();
    private final String dashboardArn;
    private final String type;
    private final String status;
    private final List<Widget> widgets;
    private final RefreshSchedule refreshSchedule;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final String lastRefreshId;
    private final String lastRefreshFailureReason;
    private final Boolean terminationProtectionEnabled;

    private GetDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.type = builder.type;
        this.status = builder.status;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.lastRefreshId = builder.lastRefreshId;
        this.lastRefreshFailureReason = builder.lastRefreshFailureReason;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final DashboardType type() {
        return DashboardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DashboardStatus status() {
        return DashboardStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasWidgets() {
        return this.widgets != null && !(this.widgets instanceof SdkAutoConstructList);
    }

    public final List<Widget> widgets() {
        return this.widgets;
    }

    public final RefreshSchedule refreshSchedule() {
        return this.refreshSchedule;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final String lastRefreshId() {
        return this.lastRefreshId;
    }

    public final String lastRefreshFailureReason() {
        return this.lastRefreshFailureReason;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWidgets() ? this.widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardResponse)) {
            return false;
        }
        GetDashboardResponse other = (GetDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasWidgets() == other.hasWidgets() && Objects.equals(this.widgets(), other.widgets()) && Objects.equals(this.refreshSchedule(), other.refreshSchedule()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.lastRefreshId(), other.lastRefreshId()) && Objects.equals(this.lastRefreshFailureReason(), other.lastRefreshFailureReason()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GetDashboardResponse").add("DashboardArn", (Object)this.dashboardArn()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Widgets", this.hasWidgets() ? this.widgets() : null).add("RefreshSchedule", (Object)this.refreshSchedule()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("LastRefreshId", (Object)this.lastRefreshId()).add("LastRefreshFailureReason", (Object)this.lastRefreshFailureReason()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Widgets": {
                return Optional.ofNullable(clazz.cast(this.widgets()));
            }
            case "RefreshSchedule": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedule()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "LastRefreshId": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshId()));
            }
            case "LastRefreshFailureReason": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshFailureReason()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("LastRefreshId", LAST_REFRESH_ID_FIELD);
        map.put("LastRefreshFailureReason", LAST_REFRESH_FAILURE_REASON_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardResponse, T> g) {
        return obj -> g.apply((GetDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String type;
        private String status;
        private List<Widget> widgets = DefaultSdkAutoConstructList.getInstance();
        private RefreshSchedule refreshSchedule;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private String lastRefreshId;
        private String lastRefreshFailureReason;
        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.type(model.type);
            this.status(model.status);
            this.widgets(model.widgets);
            this.refreshSchedule(model.refreshSchedule);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.lastRefreshId(model.lastRefreshId);
            this.lastRefreshFailureReason(model.lastRefreshFailureReason);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DashboardStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Widget.Builder> getWidgets() {
            List<Widget.Builder> result = WidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<Widget.BuilderImpl> widgets) {
            this.widgets = WidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<Widget> widgets) {
            this.widgets = WidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Widget ... widgets) {
            this.widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<Widget.Builder> ... widgets) {
            this.widgets(Stream.of(widgets).map(c -> (Widget)((Widget.Builder)Widget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return this.refreshSchedule != null ? this.refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getLastRefreshId() {
            return this.lastRefreshId;
        }

        public final void setLastRefreshId(String lastRefreshId) {
            this.lastRefreshId = lastRefreshId;
        }

        @Override
        public final Builder lastRefreshId(String lastRefreshId) {
            this.lastRefreshId = lastRefreshId;
            return this;
        }

        public final String getLastRefreshFailureReason() {
            return this.lastRefreshFailureReason;
        }

        public final void setLastRefreshFailureReason(String lastRefreshFailureReason) {
            this.lastRefreshFailureReason = lastRefreshFailureReason;
        }

        @Override
        public final Builder lastRefreshFailureReason(String lastRefreshFailureReason) {
            this.lastRefreshFailureReason = lastRefreshFailureReason;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public GetDashboardResponse build() {
            return new GetDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDashboardResponse> {
        public Builder dashboardArn(String var1);

        public Builder type(String var1);

        public Builder type(DashboardType var1);

        public Builder status(String var1);

        public Builder status(DashboardStatus var1);

        public Builder widgets(Collection<Widget> var1);

        public Builder widgets(Widget ... var1);

        public Builder widgets(Consumer<Widget.Builder> ... var1);

        public Builder refreshSchedule(RefreshSchedule var1);

        default public Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return this.refreshSchedule((RefreshSchedule)((RefreshSchedule.Builder)RefreshSchedule.builder().applyMutation(refreshSchedule)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder lastRefreshId(String var1);

        public Builder lastRefreshFailureReason(String var1);

        public Builder terminationProtectionEnabled(Boolean var1);
    }
}

