/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector;
import software.amazon.awssdk.services.cloudwatch.model.SingleMetricAnomalyDetector;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetector> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(AnomalyDetector.getter(AnomalyDetector::namespace)).setter(AnomalyDetector.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AnomalyDetector.getter(AnomalyDetector::metricName)).setter(AnomalyDetector.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(AnomalyDetector.getter(AnomalyDetector::dimensions)).setter(AnomalyDetector.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stat").getter(AnomalyDetector.getter(AnomalyDetector::stat)).setter(AnomalyDetector.setter(Builder::stat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()}).build();
    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(AnomalyDetector.getter(AnomalyDetector::configuration)).setter(AnomalyDetector.setter(Builder::configuration)).constructor(AnomalyDetectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateValue").getter(AnomalyDetector.getter(AnomalyDetector::stateValueAsString)).setter(AnomalyDetector.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()}).build();
    private static final SdkField<SingleMetricAnomalyDetector> SINGLE_METRIC_ANOMALY_DETECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleMetricAnomalyDetector").getter(AnomalyDetector.getter(AnomalyDetector::singleMetricAnomalyDetector)).setter(AnomalyDetector.setter(Builder::singleMetricAnomalyDetector)).constructor(SingleMetricAnomalyDetector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMetricAnomalyDetector").build()}).build();
    private static final SdkField<MetricMathAnomalyDetector> METRIC_MATH_ANOMALY_DETECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricMathAnomalyDetector").getter(AnomalyDetector.getter(AnomalyDetector::metricMathAnomalyDetector)).setter(AnomalyDetector.setter(Builder::metricMathAnomalyDetector)).constructor(MetricMathAnomalyDetector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricMathAnomalyDetector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, STAT_FIELD, CONFIGURATION_FIELD, STATE_VALUE_FIELD, SINGLE_METRIC_ANOMALY_DETECTOR_FIELD, METRIC_MATH_ANOMALY_DETECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final String stat;
    private final AnomalyDetectorConfiguration configuration;
    private final String stateValue;
    private final SingleMetricAnomalyDetector singleMetricAnomalyDetector;
    private final MetricMathAnomalyDetector metricMathAnomalyDetector;

    private AnomalyDetector(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.stat = builder.stat;
        this.configuration = builder.configuration;
        this.stateValue = builder.stateValue;
        this.singleMetricAnomalyDetector = builder.singleMetricAnomalyDetector;
        this.metricMathAnomalyDetector = builder.metricMathAnomalyDetector;
    }

    @Deprecated
    public final String namespace() {
        return this.namespace;
    }

    @Deprecated
    public final String metricName() {
        return this.metricName;
    }

    @Deprecated
    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    @Deprecated
    public final String stat() {
        return this.stat;
    }

    public final AnomalyDetectorConfiguration configuration() {
        return this.configuration;
    }

    public final AnomalyDetectorStateValue stateValue() {
        return AnomalyDetectorStateValue.fromValue(this.stateValue);
    }

    public final String stateValueAsString() {
        return this.stateValue;
    }

    public final SingleMetricAnomalyDetector singleMetricAnomalyDetector() {
        return this.singleMetricAnomalyDetector;
    }

    public final MetricMathAnomalyDetector metricMathAnomalyDetector() {
        return this.metricMathAnomalyDetector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stat());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleMetricAnomalyDetector());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricMathAnomalyDetector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetector)) {
            return false;
        }
        AnomalyDetector other = (AnomalyDetector)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricName(), other.metricName()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.stat(), other.stat()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.stateValueAsString(), other.stateValueAsString()) && Objects.equals(this.singleMetricAnomalyDetector(), other.singleMetricAnomalyDetector()) && Objects.equals(this.metricMathAnomalyDetector(), other.metricMathAnomalyDetector());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetector").add("Namespace", (Object)this.namespace()).add("MetricName", (Object)this.metricName()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Stat", (Object)this.stat()).add("Configuration", (Object)this.configuration()).add("StateValue", (Object)this.stateValueAsString()).add("SingleMetricAnomalyDetector", (Object)this.singleMetricAnomalyDetector()).add("MetricMathAnomalyDetector", (Object)this.metricMathAnomalyDetector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Stat": {
                return Optional.ofNullable(clazz.cast(this.stat()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "StateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValueAsString()));
            }
            case "SingleMetricAnomalyDetector": {
                return Optional.ofNullable(clazz.cast(this.singleMetricAnomalyDetector()));
            }
            case "MetricMathAnomalyDetector": {
                return Optional.ofNullable(clazz.cast(this.metricMathAnomalyDetector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetector, T> g) {
        return obj -> g.apply((AnomalyDetector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String stat;
        private AnomalyDetectorConfiguration configuration;
        private String stateValue;
        private SingleMetricAnomalyDetector singleMetricAnomalyDetector;
        private MetricMathAnomalyDetector metricMathAnomalyDetector;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetector model) {
            this.namespace(model.namespace);
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.stat(model.stat);
            this.configuration(model.configuration);
            this.stateValue(model.stateValue);
            this.singleMetricAnomalyDetector(model.singleMetricAnomalyDetector);
            this.metricMathAnomalyDetector(model.metricMathAnomalyDetector);
        }

        @Deprecated
        public final String getNamespace() {
            return this.namespace;
        }

        @Deprecated
        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Deprecated
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Deprecated
        public final String getMetricName() {
            return this.metricName;
        }

        @Deprecated
        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Deprecated
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Deprecated
        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Deprecated
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getStat() {
            return this.stat;
        }

        @Deprecated
        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        @Deprecated
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(AnomalyDetectorStateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final SingleMetricAnomalyDetector.Builder getSingleMetricAnomalyDetector() {
            return this.singleMetricAnomalyDetector != null ? this.singleMetricAnomalyDetector.toBuilder() : null;
        }

        public final void setSingleMetricAnomalyDetector(SingleMetricAnomalyDetector.BuilderImpl singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector != null ? singleMetricAnomalyDetector.build() : null;
        }

        @Override
        public final Builder singleMetricAnomalyDetector(SingleMetricAnomalyDetector singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector;
            return this;
        }

        public final MetricMathAnomalyDetector.Builder getMetricMathAnomalyDetector() {
            return this.metricMathAnomalyDetector != null ? this.metricMathAnomalyDetector.toBuilder() : null;
        }

        public final void setMetricMathAnomalyDetector(MetricMathAnomalyDetector.BuilderImpl metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector != null ? metricMathAnomalyDetector.build() : null;
        }

        @Override
        public final Builder metricMathAnomalyDetector(MetricMathAnomalyDetector metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector;
            return this;
        }

        public AnomalyDetector build() {
            return new AnomalyDetector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetector> {
        @Deprecated
        public Builder namespace(String var1);

        @Deprecated
        public Builder metricName(String var1);

        @Deprecated
        public Builder dimensions(Collection<Dimension> var1);

        @Deprecated
        public Builder dimensions(Dimension ... var1);

        @Deprecated
        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        @Deprecated
        public Builder stat(String var1);

        public Builder configuration(AnomalyDetectorConfiguration var1);

        default public Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return this.configuration((AnomalyDetectorConfiguration)((AnomalyDetectorConfiguration.Builder)AnomalyDetectorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder stateValue(String var1);

        public Builder stateValue(AnomalyDetectorStateValue var1);

        public Builder singleMetricAnomalyDetector(SingleMetricAnomalyDetector var1);

        default public Builder singleMetricAnomalyDetector(Consumer<SingleMetricAnomalyDetector.Builder> singleMetricAnomalyDetector) {
            return this.singleMetricAnomalyDetector((SingleMetricAnomalyDetector)((SingleMetricAnomalyDetector.Builder)SingleMetricAnomalyDetector.builder().applyMutation(singleMetricAnomalyDetector)).build());
        }

        public Builder metricMathAnomalyDetector(MetricMathAnomalyDetector var1);

        default public Builder metricMathAnomalyDetector(Consumer<MetricMathAnomalyDetector.Builder> metricMathAnomalyDetector) {
            return this.metricMathAnomalyDetector((MetricMathAnomalyDetector)((MetricMathAnomalyDetector.Builder)MetricMathAnomalyDetector.builder().applyMutation(metricMathAnomalyDetector)).build());
        }
    }
}

